package com.brownsoft.ag;

import java.util.*;

/**
 * Esta es la interfaz que deben implementar las clases que quieran setear
 * condiciones de parada especiales, o poblaciones iniciales deterministicas,etc
 * @author Gustavo Brown
 * @version 1.0
 */
public interface IGeneracion extends IMotorListener
{
   public void inicializar(MotorAG motor);

   /** Obtiene la poblacion inicial
    * @return Vector con la poblacion
    */
   public Vector getPoblacionInicial();

   /** Obtiene el tamao del pool de mezclas
    * @return tamao del mating pool
    */
   public int getMatingSize();

   /** Indica si se debe terminar las iteraciones
    * @return boolean indicando si se deben terminar las iteraciones
    */
   public boolean getFinalizarIteracion();

   /** Obtiene la probabilidad de cruzamiento
    * @return double con la probabilidad de cruzamiento
    */
   public double getpCross();

   /** Obtiene la probabilidad de mutacion
    * @return double con la probabilidad de mutacion
    */
   public double getpMutacion();
}
