package com.brownsoft.ag;

import java.util.*;

/**
 * Esta es la interfaz que deben implementar las clases que quieran ser utilizadas
 * como operador de seleccin
 * @author Gustavo Brown
 * @version 1.0
 */
public interface ISeleccion extends IMotorListener
{
   /** Inicializa el operador de seleccion
    * @param motor MotorAG asociado
    */
   public void inicializar(MotorAG motor);

   /** Selecciona individuos
    * @return IIndividuo[] con los individuos seleccionados
    */
   public IIndividuo[] seleccionar();

   /** Genera una nueva poblacion a partir de un pool
    * @return Vector con la nueva poblacion
    */
   public Vector generarNuevaPoblacion();

   /** Pone individuos en el pool intermedio
    * @param individuos individuos a ingresar en el pool intermedio
    */
   public void ponerEnPoolIntermedio(IIndividuo[] individuos);
}
