package com.brownsoft.ag;

import java.io.*;

/** Clase utilitaria para indicar una excepcion del motor
 * @author Gustavo Brown
 * @version 1.0
 */
public class MotorError extends Error
{
   private Exception containedException;

   /** Excepcion simple, contiene el mensaje de error
    */
   public MotorError(String msg)
   {
      this(msg, null);
   }

   /** Excepcion contenida: contiene la excepcin real que ocurri
    */
   public MotorError(String msg, Exception containedException)
   {
      super(msg);
      this.containedException = containedException;
   }

   public Exception getContainedException()
   {
      return containedException;
   }

   public void printStackTrace()
   {
      super.printStackTrace();

      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace();
      }
   }

   public void printStackTrace(PrintWriter writer)
   {
      super.printStackTrace(writer);
      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace(writer);
      }
   }

   public void printStackTrace(PrintStream stream)
   {
      super.printStackTrace(stream);
      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace(stream);
      }
   }
}
