package com.brownsoft.ag.fitnessScaler;

import com.brownsoft.ag.*;

/** Este scaler realiza la operacion (1/fitness) con lo cual invierte el tipo de optimizacion
 *  Es decir, que para cada fitness que llega en la cadena, retorna el inverso de ese fitness
 * @author Gustavo Brown
 * @version 1.0
 */

public class FitnessScalerInversa extends FitnessScaler
{

   /** Constructor
    *  @param parent El parent de este fitness scaler (o FitnessScalerSink)
    */
   public FitnessScalerInversa(IFitnessScaler parent)
   {
      super(parent);
   }

   /** Este metodo debe ser definido por las subclases de FitnessScaler
    *  @return fitness escalado (1/fitness)
    */
   protected double scaleFitness(double fitness)
   {
      return (1.0 / fitness);
   }
}