package com.brownsoft.ag.fitnessScaler;

import com.brownsoft.ag.*;

/** Esta clase implementa el ltimo eslabon de una cadena de FitnessScalers
 *  Es decir, que por ejemplo puedo definir una cadena de scalers de esta manera
 *  motor.setFitnessScaler(new FitnessScalerAxB(new FitnessScalerPositive(new FitnessScalerSink()), 2,3));
 * @author Gustavo Brown
 * @version 1.0
 */
public final class FitnessScalerSink implements IFitnessScaler
{
   /** Crea una instancia de FitnessScalerSink
    */
   public FitnessScalerSink()
   {
      ;
   }

   protected MotorAG motor;
   protected IIndividuo processingIndividual = null;

   /** Setea el motor asociado a este FitnessScaler
    *  Este metodo es ejecutado por MotorAG
    *  @param motor el MotorAG
    */
   public final void initScaler(MotorAG motor)
   {
      this.motor = motor;
   }

   /** Escala un fitness
    *  @param individuo individuo a obtener su fitness
    *  @return fitness escalado
    */
   public final double getScaledFitness(IIndividuo individuo)
   {
      processingIndividual = individuo;
      return motor.getNonScaledFitness(individuo);
   }

   /** Escala un fitness
    *  @param fitness Fitness a escalar
    *  @return fitness escalado (el sink retorna el propio fitness)
    */
   public final double getScaledFitness(double fitness)
   {
      return fitness;
   }

   /** Obtiene el IIndividuo que esta siendo escalado en este momento
    **/
   public IIndividuo getProcessingIndividual()
   {
      return processingIndividual;
   }

   /** El sink no debe hacer nada aqui */
   public void fireInicioIteracion()
   {
      ;
   }

   /** El sink no debe hacer nada aqui */
   public void inicioIteracion()
   {
      ;
   }
}