package com.brownsoft.ag.individuo;

import com.brownsoft.ag.*;

/** Esta clase es utilizada para crear individuos multiparmetros
 * Cada uno de los parametros a su vez es una instancia de Individuo
 * La clase es abstracta, pues se deja a las subclases el trabajo de definir
 * el fenotipo y el fitness.
 * Con la funcion getParameter(int index) se obtiene el parametro numero 'index'
 * @see OperadorMultiple
 * @author Gustavo Brown
 * @version 1.0
 */
public class IndividuoMultipleFuncionExpresion extends IndividuoMultiple
{
   private EvaluaExpresion eval;
   /** Constructor
    * @param parametros Array de IIndividuo con los parametros de este individuo
    */
   public IndividuoMultipleFuncionExpresion(String expresion, IIndividuo[] parametros)
   {
      super(parametros);
      eval = new EvaluaExpresion(expresion);
      for (int i = 0; i < parametros.length; i++)
      {
         if (parametros[i] instanceof FuncionExpresion)
         {
            ( (FuncionExpresion) parametros[i]).setIsPartOfComplexIndividual(i, this);
         }
      }
   }

   /** Evalua y retorna el fitness de este individuo
    * @return  retorna el fitness de este individuo
    */
   public double getFitness()
   {
      return eval.getFitness(this);
   }

   /** Obtiene el evaluador de la expresion de este individuo
    * @return EvaluaExpresion evaluador de la expresion de este individuo
    */
   public EvaluaExpresion getEvaluator()
   {
      return eval;
   }

   /** Obtiene el fenotipo de este individuo
    * Este mtodo deberia ser definido por las subclases
    */
   public Object getFenotipo()
   {
      throw new MotorError("No se ha definido el metodo getFenotipo para esta clase (" + getClass().getName());
   }

   public IndividuoMultipleFuncionExpresion doClone()
   {
      try
      {
         return (IndividuoMultipleFuncionExpresion)this.clone();
      }
      catch (CloneNotSupportedException e)
      {
         return null;
      }
   }
}
