package com.brownsoft.codec;

/**
 * Esta clase mapea simbolos con codewords
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class HuffmanNode
{
   private long [] nodeStream;
   private int size;
   private double probability;
   private HuffmanNode node1, node2;
   private boolean isComplex = false;
   private int symbol;
   private boolean isValid = false;

   public HuffmanNode(int symbol, double probability)
   {
      this.symbol = symbol;
      this.probability = probability;
      this.size = -1;
   }

   public HuffmanNode(HuffmanNode node1, HuffmanNode node2)
   {
      this.probability = node1.getProbability() + node2.getProbability();
      this.node1 = node1;
      this.node2 = node2;
      isComplex = true;
   }

   public double getProbability()
   {
      return probability;
   }

   public void setNode(long [] node, int size)
   {
      if(isValid)
      {
         throw new Error("Este nodo ya tiene una codeword asociada: " + toString());
      }
			if(isComplex)
      {
        // Calculo la posicion del bit de este nodo complejo
        int pos = size % 64;
				if(pos == 0)
        { // Si se debe agrandar el tamao del array
           long [] newNode = new long[node.length + 1];
           System.arraycopy(node, 0, newNode, 0, node.length);
           node = newNode;
        }
        size++;

        long [] nodeStream1 = (long[])node.clone();
        long [] nodeStream2 = (long[])node.clone();

        // El nodo 2 tiene un 1 en la posicion pos
        nodeStream2[node.length - 1] |= (1 << pos);
        node1.setNode(nodeStream1, size);
        node2.setNode(nodeStream2, size);
      }
      else
      { // Si soy una hoja del rbol
        if(size == 0)
        { // Hay un caso de borde cuando solo hay un simbolo
           size++;
           node = new long[]{0};
        }
      	nodeStream = node;
        this.size = size;
        isValid = true;
      }
   }

   public int getSymbol()
   {
      return symbol;
   }

   public long [] getNode()
   {
      return nodeStream;
   }

   public int getSize()
   {
      return size;
   }

    public String toString()
    {
       String ret = Integer.toHexString(symbol) + " [prob=" + ensure20(getProbability()) + "]: ";

       int idx = size / 64;
       int pos = size % 64;
       for(int i = 0; i <= idx; i++)
       {
          long node = nodeStream[i];
          for(; pos > 0; pos--)
          {
	          ret += (node & 1);
            node >>= 1;
          }
          pos = 64;
       }
       return ret;
    }

    private String ensure20(double value)
    {
       String retVal = Double.toString(value);
       while(retVal.length() < 20)
       {
          retVal += "0";
       }
       return retVal;
    }

 	  /** Indica si este nodo es vlido, es decir si mapea un simbolo con una codeword */
    public boolean isValid()
    {
       return isValid;
    }
}