package com.brownsoft.image;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.awt.event.*;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class PGMDecoder
{
   private int width, height;
   private DataInputStream inputStream;
   private int []buffer;
   private double [][]matrix;
   protected String ImageType;
   protected String HeaderId;
   protected int BandCount;
   protected int ColorType;

   public PGMDecoder(InputStream stream, String ImageType, String HeaderId, int BandCount, int ColorType)throws IOException
   {
      inputStream = new DataInputStream(new BufferedInputStream(stream));
      this.ImageType = ImageType;
      this.HeaderId = HeaderId;
      this.BandCount = BandCount;
      this.ColorType = ColorType;
   }

   public PGMDecoder(InputStream stream)throws IOException
   {
      this(stream, "PGM", "P5", 1, BufferedImage.TYPE_BYTE_GRAY);
   }

   protected String filename;
   public PGMDecoder(String filename) throws IOException
   {
      this(new FileInputStream(filename));
      this.filename = filename;
   }

   public int getVector()[] throws IOException
   {
      if(buffer != null)
      {
         return buffer;
      }
      String imageType = getLine();
      if(!imageType.equalsIgnoreCase(HeaderId))
      {
         throw new IOException("Header invlido: La imagen no es del tipo " + ImageType);
      }
      String imageSize = getLine();
      int index = imageSize.indexOf(" ");
      if(index == -1)
      {
         throw new IOException("Header invlido: No se puede determinar el tamao de la imagen");
      }
      width = Integer.parseInt(imageSize.substring(0, index));
      height = Integer.parseInt(imageSize.substring(index+1));

      String pixelRange = getLine();
      if(Integer.parseInt(pixelRange) != 255)
      {
         throw new IOException("Solo se puede decodificar imagenes de 8 bpp");
      }

      byte [] bytes = new byte[width * height * BandCount];
      inputStream.readFully(bytes);
      buffer = new int[bytes.length];
      for(int i = 0; i < bytes.length; i++)
      {
         buffer[i] = (bytes[i] > 0 ? bytes[i] : ((int)(bytes[i] + 128))+128);
      }
      inputStream.close();
      return buffer;
   }

   /** Decodifica la imagen y retorna una matrix con los datos */
   public double [][] getMatrix()
   {
      if(matrix != null)
      {
         return matrix;
      }
      matrix = new double[height][width];
      int k = 0;
      for(int j = 0; j < height; j++)
      {
         for(int i = 0; i < width; i++)
         {
            matrix[j][i] = buffer[k++];
         }
      }
      return matrix;
   }

   public Image getImage()throws IOException
   {
      int [] buffer = getVector();
      BufferedImage image = new BufferedImage(width, height, ColorType);
      WritableRaster raster = image.getRaster();
      raster.setPixels(0, 0, width, height, buffer);
      return image;
   }

   /** Obtiene una linea de texto de la imagen, obviando los comentarios */
   private String getLine()throws IOException
   {
      while(true)
      {
	      String line = inputStream.readLine().trim();
          if(line == null)throw new IOException("Formato invlido");
          if(line.startsWith("#"))
          {// Si es un comentario, debo leer la siguiente linea
             continue;
          }
          return line;
      }
   }

   public void showImage()
   {
      try
      {
         Frame frame = new Frame("PGMDecoder (u)2004, Gustavo Brown" + (filename != null ? " - '" + filename + "'" : ""));
         frame.add(new ImageCanvas(getImage()));
	frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               evt.getWindow().dispose();
            }
         });
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }

   public static void main(String [] args)
   {
      System.err.println("PGMDecoder, (u)2004, Gustavo Brown");
      System.err.println();
      if(args.length < 1)
      {
         System.err.println("Argumento: Nombre de archivo .pgm");
         return;
      }
      try
      {
         String file = args[0];
         Frame frame = new Frame("PGMDecoder (u)2004, Gustavo Brown - '" + file + "'");
         frame.add(new ImageCanvas(new PGMDecoder(file).getImage()));
         frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               System.exit(0);
            }
         });
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }


}