package com.brownsoft.image;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.awt.event.*;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class PPMDecoder extends PGMDecoder
{
   public PPMDecoder(InputStream stream)throws IOException
   {
      super(stream, "PPM", "P6", 3, BufferedImage.TYPE_INT_RGB);
   }

   public PPMDecoder(String filename) throws IOException
   {
      this(new FileInputStream(filename));
   }

   public static void main(String [] args)
   {
      System.err.println("PPMDecoder, (u)2004, Gustavo Brown");
      System.err.println();
      if(args.length < 1)
      {
         System.err.println("Argumento: Nombre de archivo .ppm");
         return;
      }
      try
      {
         String file = args[0];
         Frame frame = new Frame("PPMDecoder (u)2004, Gustavo Brown - '" + file + "'");
         frame.add(new ImageCanvas(new PPMDecoder(file).getImage()));
         frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               System.exit(0);
            }
         });
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }


}