package com.brownsoft.image;

import java.awt.*;
import java.awt.event.*;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class ImageCanvas extends Canvas
{
   Image img;
   Image imgToShow;
   public ImageCanvas(Image img)
   {
      this.img = img;
      setSize(img.getWidth(this), img.getHeight(this));
      imgToShow = img;
      this.addComponentListener(new ComponentAdapter()
      {
         public void componentResized(ComponentEvent evt)
         {
            rescale();
         }
      });
   }

   public void paint(Graphics g)
   {
      g.drawImage(imgToShow, 0, 0, this);
   }

   public void rescale()
   {
		imgToShow = img.getScaledInstance(getWidth(), getHeight(), 0);
   }

   public static void showImage(Image image)
   {
      showImage("ImageShow", image);
   }

   public static void showImage(String title, Image image)
   {
      try
      {
         Frame frame = new Frame(title + " - (u)2004, Gustavo Brown");
         frame.add(new ImageCanvas(image));
         frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               evt.getWindow().dispose();
            }
         });
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}