package com.brownsoft.klt;
import com.brownsoft.image.*;
import com.brownsoft.codec.*;
import java.io.File;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class DecodeKLT
{
   public static void main(String []args)
   {
      System.err.println("DecodeKLT v1.0, (u)2004, Gustavo Brown Rodriguez");
      System.err.println();
      String file = null;
      if(args.length > 0)
      {
         if(new File(args[args.length-1]).isFile())
         {
            file = args[args.length-1];
         }
         else
         {
	         if(new File(args[args.length-1] + ".klti").isFile())
             {
                file = args[args.length-1] + ".klti";
             }
         }
      }
      if(file == null)
      {
         System.err.println("USO: com.brownsoft.klt.EncodeKLT [Argumentos] Nombre de archivo .klti");
         System.err.println();
         System.err.println("Argumentos:");
         System.err.println("\t-kNombre Codificar usando la base de la klt a partir del archivo .kltc");
         System.err.println("\t-n Mostrar decodificacin de cada canal");
         return;
      }

      boolean useExternalKLTBase = false;
      boolean showBands = false;
      String externalKLTBase = null;

      for(int i = 0; i < args.length - 1; i++)
      {
         String arg = args[i].trim();
         if(arg.length() == 0)continue;
         if(arg.charAt(0) != '-')
         {
            System.err.println("Ignorando parametro: '" + arg + "'");
            continue;
         }
         if(arg.length() == 1)continue;
         String parm = arg.substring(2);
         switch(arg.charAt(1))
         {
         	case 'n':
             	showBands = true;
                 break;
            case 'k':
            	useExternalKLTBase = true;
                externalKLTBase = parm;
                if(externalKLTBase.indexOf('.') == -1)
                {
                   externalKLTBase += ".kltc";
                }
                break;
            default:
            	System.err.println("Argumento no reconocido: " + arg);
         }
      }

      try
      {
         KLTDecoder decoder = new KLTDecoder(file);
         System.err.println("Tamao de la imagen: " + decoder.getImageSize().x + "x" + decoder.getImageSize().y);
         System.err.println("Tipo de la imagen: " + getImageType(decoder.getImageType()));
         System.err.println("Tamao del bloque: " + decoder.getBlockSize());
         System.err.println("Comentario: " + decoder.getComment());
         System.err.println("BitsPerPixel: " + ((double)new File(file).length()*8/(decoder.getImageSize().x * decoder.getImageSize().y)));
         if(decoder.getKLTVectorsEmbeded())
         {
            System.err.println("Coeficientes de la base: embebidos");
         }
         else
         {
            if(!useExternalKLTBase)
            { // Si no indico el archivo de donde obtener la base, vemos si existe uno
               externalKLTBase = file;
               if (externalKLTBase.endsWith(".klti"))
               {
                  externalKLTBase = externalKLTBase.substring(0, externalKLTBase.length() - 5) + ".kltc";
               }
               if (externalKLTBase.indexOf('.') == -1)
               {
                  externalKLTBase += ".kltc";
               }
               if(!new File(externalKLTBase).isFile())
               {
                  System.err.println("Debe indicar un archivo de coeficientes (.kltc) mediante el argumento -k");
                  return;
               }
               else
               {
                  useExternalKLTBase = true;
               }
            }
         }
         if(useExternalKLTBase)
         {
            System.err.println("Utilizando coeficientes del archivo: '" + externalKLTBase + "'");
            decoder.setKLTBaseName(externalKLTBase);
         }
         decoder.setShowBands(showBands);
         System.err.println();
         ImageCanvas.showImage(file, decoder.decode());
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }

   private static String getImageType(int type)
   {
      switch(type)
      {
         case KLTDecoder.IMAGE_GRAY: return "Escala de grises";
         case KLTDecoder.IMAGE_RGB: return "Color RGB";
         case KLTDecoder.IMAGE_YCrCb: return "Color YCrCb";
         default: return "Desconocido";
      }
   }
}