package com.brownsoft.image;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.awt.event.*;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class PGMEncoder
{
   int [] imageVector;
   double [][]imageMatrix;
   int width, height;

   protected String ImageType;
   protected String HeaderId;
   protected int BandCount;
   protected int ColorType;

   public PGMEncoder(double [][] imageMatrix)
   {
      this(imageMatrix, "PGM", "P5", 1, BufferedImage.TYPE_BYTE_GRAY);
   }

   public PGMEncoder(double [][]imageMatrix, String ImageType, String HeaderId, int BandCount, int ColorType)
   {
      this.ImageType = ImageType;
      this.HeaderId = HeaderId;
      this.BandCount = BandCount;
      this.ColorType = ColorType;

      this.imageMatrix = imageMatrix;
      this.width = imageMatrix[0].length;
      this.height = imageMatrix.length;
      setImageVector();
   }

   private void setImageVector()
   {
      imageVector = new int[width * height];
      int k = 0;
      for(int j = 0; j < height; j++)
      {
         for(int i = 0; i < width; i++)
         {
            imageVector[k++] = (int)imageMatrix[j][i];
            if(imageVector[k-1] < 0)
            {
               imageVector[k-1] = -imageVector[k-1];
            }
            if(imageVector[k-1] >255)
            {
               imageVector[k-1] = 255;
            }
         }
      }
   }

   public Image getImage()
   {
      BufferedImage image = new BufferedImage(width, height, ColorType);
      WritableRaster raster = image.getRaster();
      raster.setPixels(0, 0, width, height, imageVector);
      return image;
   }

   public void showImage(String title)
   {
      try
      {
         Frame frame = new Frame(title + " - PGMEncoder (u)2004, Gustavo Brown");
         frame.add(new ImageCanvas(getImage()));
         frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               evt.getWindow().dispose();
            }
         });
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}