package com.brownsoft.klt;
import java.io.*;
import com.brownsoft.image.*;
import com.brownsoft.codec.*;
import java.awt.*;

/**
 * <p>Title: Proyecto Codificacion de Imagenes y Video</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author Gustavo Brown (alegus@adinet.com.uy)
 * @version 1.0
 */

public class EncodeKLT
{
   String [] args;

   public static void main(String []args)
   {
      System.err.println("EncodeKLT v1.0, (u)2004, Gustavo Brown Rodriguez");
      System.err.println();
      String file = null;
      if(args.length > 0)
      {
         if(new File(args[args.length-1]).isFile())
         {
            file = args[args.length-1];
         }
      }
      if(file == null)
      {
         System.err.println("USO: com.brownsoft.klt.EncodeKLT [Argumentos] Archivo .pgm/.ppm/.jpg/.gif");
         System.err.println();
         System.err.println("Argumentos:");
         System.err.println("\t-bN Tamao de bloque NxN (4-64), por defecto=8");
         System.err.println("\t-cN Cantidad de coeficientes a considerar, por defecto=2*tamao bloque");
         System.err.println("\t-qN Calidad (1-100)");
         System.err.println("\t-j[Nombre] Guardar base de la klt [en el archivo indicado]");
         System.err.println("\t-kNombre Codificar usando la base de la klt a partir del archivo .kltc");
         System.err.println("\t-y Codificar imagen color en espacio YCrCb (valor por defecto)");
         System.err.println("\t-r Codificar imagen color en espacio RGB");
         System.err.println("\t-g Codificar imagen color en escala de grises");
         System.err.println("\t-oNombre Nombre del archivo de salida");
         System.err.println("\t-m\"Msg\" Comentario asociado a la imagen");
         System.err.println("\t-n Mostrar codificacin de cada canal");
         System.err.println("\t-s Mostrar imagen de entrada");
         System.err.println("\t-p Mostrar progreso de la codificacion");
         return;
      }
      try
      {
         EncodeKLT encoder = new EncodeKLT(args);
         encoder.process();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }

   public EncodeKLT(String [] args)
   {
      this.args = args;
   }

   private String getOutFile(String file)
   {
      String inFile = File.separator + new File(file).getAbsolutePath();
      int index = inFile.lastIndexOf(File.separator);
      int index2 = inFile.lastIndexOf('.');
      if(index2 == -1 || index2 < index)
      {
         return file + ".klti";
      }
      else
      {
         return file.substring(0, file.lastIndexOf('.')) + ".klti";
      }
   }

   public void process() throws IOException
   {
      String file = args[args.length-1];
      Image image;
//      PGMDecoder decoder;
      if (file.toLowerCase().endsWith(".ppm"))
      {
//         decoder = new PPMDecoder(file);
         image = new PPMDecoder(file).getImage();
      }
      else if(file.toLowerCase().endsWith(".pgm"))
      {
//         decoder = new PGMDecoder(file);
         image = new PGMDecoder(file).getImage();
      }
      else
      {
         image = Toolkit.getDefaultToolkit().getImage(file);
      }
      KLTEncoder encoder = new KLTEncoder(image);

      // Ahora parseo los argumentos

      int cantCoeffs = -1;
      int blockSize = 8;
      int quality = -1;
      String outFile = getOutFile(file);
      String comment = "";
      boolean showBands = false;
      boolean showInputImage = false;
      boolean showProgress = false;
      byte outputImageType = KLTEncoder.IMAGE_YCrCb;
      boolean useExternalKLTBase = false;
      boolean createExternalKLTBase = false;
      String externalKLTBase = null;
      String externalLoadKLTBase = null;

      for(int i = 0; i < args.length - 1; i++)
      {
         String arg = args[i].trim();
         if(arg.length() == 0)continue;
         if(arg.charAt(0) != '-')
         {
            System.err.println("Ignorando parametro: '" + arg + "'");
            continue;
         }
         if(arg.length() == 1)continue;
         String parm = arg.substring(2);
         switch(arg.charAt(1))
         {
            case 'b':
            	blockSize = Integer.parseInt(parm);
                if(blockSize < 4 || blockSize > 64)
                {
                   System.err.println("El tamao del bloque debe ser entre 4 y 64");
                }
                break;
            case 'c':
            	cantCoeffs = Integer.parseInt(parm);
                if(cantCoeffs < 1 || cantCoeffs > blockSize*blockSize)
                {
                   System.err.println("La cantidad de coeficientes debe ser menor que el blockSize^2");
                }
                break;
             case 'q':
                quality = Integer.parseInt(parm);
                if (quality < 1 || quality > 100)
                {
                   System.err.println("La calidad debe valer entre 1 y 100");
                }
                break;
             case 'o':
                outFile = parm;
                if (outFile.indexOf('.') == -1)
                {
                   outFile += ".klti";
                }
                break;
             case 'm':
                comment = parm;
                break;
             case 'n':
                showBands = true;
                break;
             case 's':
                showInputImage = true;
                break;
             case 'p':
            	showProgress = true;
                Jama.EigenvalueDecomposition.DEBUG=true;
                break;
            case 'y':
/*
if(decoder.getClass() == PGMDecoder.class)
                {
                 	System.err.println("No se puede utilizar el argumento -y en imagenes en escalas de grises");
                }
                else
                {
*/
	            	outputImageType = KLTEncoder.IMAGE_YCrCb;
//                }
                break;
            case 'r':
	            outputImageType = KLTEncoder.IMAGE_RGB;
                break;
            case 'g':
            	outputImageType = KLTEncoder.IMAGE_GRAY;
                break;
            case 'j':
            	if(parm.startsWith("[") && arg.endsWith("]"))
                {
                   System.err.println("Los [ ] indican parametro opcional");
                   parm = parm.substring(1, parm.length()-2);
                }
                createExternalKLTBase = true;
                if(!parm.equals(""))
                {
                   externalKLTBase = parm;
                }
            	break;
            case 'k':
            	useExternalKLTBase = true;
                externalLoadKLTBase = parm;
                break;
            default:
            	System.err.println("Argumento no reconocido: " + arg);
         }
      }

      if(createExternalKLTBase)
      {
         if(externalKLTBase == null)
         {
            externalKLTBase = outFile;
            if(externalKLTBase.endsWith(".klti"))
            {
               externalKLTBase = externalKLTBase.substring(0, externalKLTBase.length() - 5) + ".kltc";
            }
         }
         if(externalKLTBase.indexOf('.') == -1)
         {
            externalKLTBase += ".kltc";
         }
         encoder.setKLTBaseOutputName(externalKLTBase);
         encoder.setEmbedKLTVectors(false);
      }

      if(useExternalKLTBase)
      {
         if(externalLoadKLTBase.indexOf('.') == -1)
         {
            externalLoadKLTBase += ".kltc";
         }
         encoder.setKLTBaseName(externalLoadKLTBase);
      }

      encoder.setComment(comment);
      encoder.setBlockSize(blockSize);
      if(cantCoeffs != -1)
      {
	      encoder.setNumberOfCoefficients(cantCoeffs);
      }
      else
      {
         encoder.setNumberOfCoefficients(2*blockSize);
      }
      if(quality != -1)
      {
         encoder.setQuality(quality);
      }
      if(showInputImage)
      {
         ImageCanvas.showImage(file, image);
//         decoder.showImage();
      }
      encoder.setShowBands(showBands);
      encoder.setShowProgress(showProgress);
      encoder.setOutputImageType(outputImageType);

      encoder.encodeImage(outFile);
   }

}