/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import com.brownsoft.codec.HuffmanMultiplexerBitInputStream;
import com.brownsoft.codec.KLTConstants;
import com.brownsoft.codec.KLTException;
import com.brownsoft.codec.KLTHelper;
import com.brownsoft.image.PGMEncoder;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KLTDecoder
implements KLTConstants {
    private boolean ownerInputStream = false;
    private DataInputStream dataStream;
    private String comment = "";
    private int quality;
    private int coefficients;
    private boolean useQuantization;
    private boolean embedKLTVectors;
    private byte imageType;
    private int imageWidth;
    private int imageHeight;
    private BufferedImage image;
    private HuffmanMultiplexerBitInputStream huffmanDecoder;
    private HuffmanMultiplexerBitInputStream externalKLTReader;
    private double[][][] imageMatrix;
    private int currentBand;
    protected int BLOCK_WIDTH;
    protected int BLOCK_SIZE;
    private boolean showBands = false;
    private boolean useExternalKLTBase = false;
    private String externalKLTBaseInputName;

    public KLTDecoder(String filename) throws IOException {
        this(new FileInputStream(filename));
        this.ownerInputStream = true;
    }

    public KLTDecoder(InputStream inputStream) throws IOException {
        this.dataStream = new DataInputStream(inputStream);
        this.readHeader();
    }

    public void setShowBands(boolean showBands) {
        this.showBands = showBands;
    }

    public boolean getShowBands() {
        return this.showBands;
    }

    public String getComment() {
        return this.comment;
    }

    public int getBlockSize() {
        return this.BLOCK_WIDTH;
    }

    public int getImageType() {
        return this.imageType;
    }

    public Point getImageSize() {
        return new Point(this.imageWidth, this.imageHeight);
    }

    public boolean getKLTVectorsEmbeded() {
        return this.embedKLTVectors;
    }

    public void setKLTBaseName(String kltBaseName) {
        this.useExternalKLTBase = true;
        this.externalKLTBaseInputName = kltBaseName;
    }

    public Image decode() throws KLTException {
        try {
            if (this.image == null) {
                this.decodeImage();
            }
            return this.image;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KLTException("Ocurrio un error de IO al decodificar la imagen: " + e.getMessage());
        }
    }

    private void decodeImage() throws IOException, KLTException {
        this.decompressImage();
        if (this.ownerInputStream) {
            this.dataStream.close();
        }
    }

    private void readHeader() throws IOException, KLTException {
        byte flags;
        byte[] tmp = new byte["KLT 1.0 - (u)2004, Gustavo Brown.".length()];
        this.dataStream.readFully(tmp);
        if (!new String(tmp).equals("KLT 1.0 - (u)2004, Gustavo Brown.")) {
            throw new KLTException("El archivo no tiene el format correcto [FormatString]");
        }
        short commentSize = this.dataStream.readShort();
        if (commentSize > 0) {
            tmp = new byte[commentSize];
            this.dataStream.readFully(tmp);
            this.comment = new String(tmp);
        }
        this.embedKLTVectors = ((flags = this.dataStream.readByte()) & 1) != 0;
        this.imageType = (byte)(flags >> 1 & 3);
        this.setBlockSize(this.dataStream.readByte());
        this.setQuality(this.dataStream.readByte() & 0xFF);
        this.imageWidth = this.dataStream.readShort();
        this.imageHeight = this.dataStream.readShort();
    }

    private void decompressImage() throws IOException {
        switch (this.imageType) {
            case 0: {
                this.imageMatrix = new double[1][this.imageHeight][this.imageWidth];
                break;
            }
            case 2: 
            case 3: {
                this.imageMatrix = new double[3][this.imageHeight][this.imageWidth];
            }
        }
        HuffmanMultiplexerBitInputStream kltReader = this.huffmanDecoder = new HuffmanMultiplexerBitInputStream(this.dataStream);
        if (this.useExternalKLTBase) {
            this.openExternalKLTBase();
            kltReader = this.externalKLTReader;
        } else if (!this.embedKLTVectors) {
            throw new KLTException("La imagen no tiene la base de la KLT embebida y no se ha especificado un archivo de coeficientes (.kltc)");
        }
        int cantBands = this.imageMatrix.length;
        double[][][] imageBand = new double[cantBands][this.imageHeight][this.imageWidth];
        this.currentBand = 0;
        while (this.currentBand < cantBands) {
            double[][] encodedImageMatrixCoeffs = new double[this.getCantBlocks(this.currentBand)][this.BLOCK_SIZE];
            double lastDC = 0.0;
            int i = 0;
            while (i < encodedImageMatrixCoeffs.length) {
                lastDC = this.decodeBlock(encodedImageMatrixCoeffs[i], lastDC);
                ++i;
            }
            int currentBandLeastUsedCoeff = kltReader.readUnencoded(16);
            double[][] invBasis = new double[this.BLOCK_SIZE][this.BLOCK_SIZE];
            int i2 = this.BLOCK_SIZE - 1;
            while (i2 >= currentBandLeastUsedCoeff) {
                int j = 0;
                while (j < this.BLOCK_SIZE) {
                    int cantBitsNeeded = kltReader.read(4);
                    invBasis[i2][j] = this.getDoubleFromVLI(kltReader, cantBitsNeeded) / 100.0;
                    ++j;
                }
                --i2;
            }
            imageBand[this.currentBand] = this.imageType != 3 || this.currentBand == 0 ? KLTHelper.apply(invBasis, this.imageWidth, this.imageHeight, this.BLOCK_WIDTH, encodedImageMatrixCoeffs) : KLTHelper.apply(invBasis, this.imageWidth / 2, this.imageHeight / 2, this.BLOCK_WIDTH, encodedImageMatrixCoeffs);
            if (this.showBands) {
                PGMEncoder decodedImage = new PGMEncoder(imageBand[this.currentBand]);
                decodedImage.showImage(this.getBandName());
            }
            System.gc();
            ++this.currentBand;
        }
        if (this.imageType == 3) {
            imageBand = this.expandSubSampling(imageBand);
            imageBand = KLTHelper.convertToRGB(imageBand);
        }
        this.image = new BufferedImage(this.imageWidth, this.imageHeight, this.getBufferedImageType());
        int[] imageData = new int[this.imageHeight * this.imageWidth * cantBands];
        int k = 0;
        int j = 0;
        while (j < this.imageHeight) {
            int i = 0;
            while (i < this.imageWidth) {
                int currentBand = 0;
                while (currentBand < cantBands) {
                    double value = imageBand[currentBand][j][i];
                    if (value > 255.0) {
                        value = 255.0;
                    } else if (value < 0.0) {
                        value = -value;
                    }
                    imageData[k++] = (int)value;
                    ++currentBand;
                }
                ++i;
            }
            ++j;
        }
        imageBand = null;
        this.image.getRaster().setPixels(0, 0, this.imageWidth, this.imageHeight, imageData);
    }

    private double decodeBlock(double[] vector, double lastDC) throws IOException {
        int cantBitsNeeded = this.huffmanDecoder.read(4);
        double currentDC = this.dequantizeDC(this.getDoubleFromVLI(cantBitsNeeded)) + lastDC;
        int curCoef = vector.length - 1;
        vector[curCoef--] = currentDC;
        int cmd = this.huffmanDecoder.read(0 + this.currentBand);
        while (cmd != 0) {
            int zeroRunLength = cmd >> 4;
            curCoef -= zeroRunLength;
            cantBitsNeeded = cmd & 0xF;
            vector[curCoef--] = this.dequantizeAC(this.getDoubleFromVLI(cantBitsNeeded), curCoef);
            cmd = this.huffmanDecoder.read(0 + this.currentBand);
        }
        return currentDC;
    }

    private double getDoubleFromVLI(HuffmanMultiplexerBitInputStream huffmanDecoder, int cantBitsNeeded) throws IOException {
        int cte;
        int value = huffmanDecoder.readUnencoded(cantBitsNeeded);
        boolean isNegative = (value & (cte = 1 << cantBitsNeeded - 1)) != 0;
        value &= ~cte;
        boolean sign = false;
        value += cte;
        if (isNegative) {
            value = -value;
        }
        return (double)value / 200.0;
    }

    private double getDoubleFromVLI(int cantBitsNeeded) throws IOException {
        return this.getDoubleFromVLI(this.huffmanDecoder, cantBitsNeeded);
    }

    private double dequantizeDC(double value) {
        return value * 10.0;
    }

    private double dequantizeAC(double value, int curCoef) {
        if (this.imageType == 3 && this.currentBand != 0) {
            return value * 200000.0 / (Math.pow(1.01, curCoef) * (double)this.quality);
        }
        return value * 80000.0 / (Math.pow(1.01, curCoef) * (double)this.quality);
    }

    private int getBufferedImageType() {
        switch (this.imageType) {
            case 0: {
                return 10;
            }
            case 2: 
            case 3: {
                return 5;
            }
        }
        throw new KLTException("Tipo de imagen no definido: " + this.imageType);
    }

    public void setBlockSize(int blockSize) throws KLTException {
        if (blockSize < 1 || blockSize > 255) {
            throw new KLTException("El tama\u00f1o del bloque debe estar entre 1 y 255");
        }
        this.BLOCK_WIDTH = blockSize;
        this.BLOCK_SIZE = blockSize * blockSize;
    }

    private int getCantBlocks(int curBand) {
        int imageWidth = this.imageWidth;
        int imageHeight = this.imageHeight;
        if (this.imageType == 3 && curBand != 0) {
            imageWidth /= 2;
            imageHeight /= 2;
        }
        int blocksWidth = (int)Math.ceil((double)imageWidth / (double)this.BLOCK_WIDTH);
        int blocksHeight = (int)Math.ceil((double)imageHeight / (double)this.BLOCK_WIDTH);
        return blocksWidth * blocksHeight;
    }

    private void setQuality(int quality) {
        this.quality = quality;
    }

    private double[][][] expandSubSampling(double[][][] imageBand) {
        if (this.imageType != 3) {
            return imageBand;
        }
        double[][][] expandedImageBand = new double[3][this.imageHeight][this.imageWidth];
        expandedImageBand[0] = imageBand[0];
        int j = 0;
        while (j < this.imageHeight) {
            int i = 0;
            while (i < this.imageWidth) {
                expandedImageBand[1][j][i] = imageBand[1][j / 2][i / 2];
                expandedImageBand[2][j][i] = imageBand[2][j / 2][i / 2];
                ++i;
            }
            ++j;
        }
        return expandedImageBand;
    }

    private String getBandName() {
        switch (this.imageType) {
            case 0: {
                return "Canal Gris";
            }
            case 2: {
                return "Canal " + (this.currentBand == 0 ? "R" : (this.currentBand == 1 ? "G" : "B"));
            }
            case 3: {
                return "Canal " + (this.currentBand == 0 ? "Y" : (this.currentBand == 1 ? "Cr" : "Cb"));
            }
        }
        return "Desconocido";
    }

    private void openExternalKLTBase() throws IOException {
        BufferedInputStream kltInputStream = new BufferedInputStream(new FileInputStream(this.externalKLTBaseInputName));
        byte[] tempBuffer = new byte[4];
        kltInputStream.read(tempBuffer);
        if (!new String(tempBuffer).equals("kltc")) {
            throw new KLTException("Archivo de coeficientes de la base de la KLT inv\u00e1lido (" + this.externalKLTBaseInputName + ")");
        }
        int embededBlockWidth = kltInputStream.read() & 0xFF;
        if (embededBlockWidth != this.BLOCK_WIDTH) {
            System.err.println("Warning: El archivo de coeficientes difiere en el tama\u00f1o del bloque");
            System.err.println("         Se utilizara como valor " + embededBlockWidth + " en vez de " + this.BLOCK_WIDTH);
            this.setBlockSize(embededBlockWidth);
        }
        this.externalKLTReader = new HuffmanMultiplexerBitInputStream(kltInputStream);
    }
}

