/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import Jama.Matrix;
import com.brownsoft.codec.HuffmanMultiplexerBitInputStream;
import com.brownsoft.codec.HuffmanMultiplexerBitStream;
import com.brownsoft.codec.KLTConstants;
import com.brownsoft.codec.KLTException;
import com.brownsoft.codec.KLTHelper;
import com.brownsoft.image.PGMEncoder;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class KLTEncoder
implements KLTConstants {
    private Image image;
    private int quality;
    private int coefficients;
    private boolean embedKLTVectors;
    private HuffmanMultiplexerBitStream huffmanMultiplexer;
    private HuffmanMultiplexerBitStream externalKLTWriter;
    private HuffmanMultiplexerBitInputStream externalKLTReader;
    private ByteArrayOutputStream stream;
    private DataOutputStream dataStream;
    private String comment = "";
    private byte imageType;
    private byte outputImageType;
    private int imageWidth;
    private int imageHeight;
    private int[] imageVector;
    private int cantBands;
    private int currentBand;
    private double[][][] imageMatrix;
    private double[][][] imageMatrixYCrCb;
    private int currentBandLeastUsedCoeff;
    private boolean showBands = false;
    private boolean showProgress;
    private String externalKLTBaseOutputName;
    private String externalKLTBaseInputName;
    private boolean useExternalKLTBase = false;
    private boolean writeExternalKLTBase = false;
    protected int BLOCK_WIDTH;
    protected int BLOCK_SIZE;
    public static final boolean DEBUG = true;

    public KLTEncoder(Image image) {
        try {
            this.image = image;
            this.setImageMatrix();
            this.setBlockSize(8);
            this.setQuality(75);
            this.setEmbedKLTVectors(true);
            this.setOutputImageType((byte)-1);
        }
        catch (KLTException e) {
            e.printStackTrace();
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setQuality(int quality) throws KLTException {
        if (quality < 0 || quality > 100) {
            throw new KLTException("La calidad debe ser entre 0 y 100");
        }
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setNumberOfCoefficients(int coefficients) throws KLTException {
        if (coefficients < 1 || coefficients > this.BLOCK_SIZE) {
            throw new KLTException("La cantidad de coeficientes debe valer entre 1 y " + this.BLOCK_SIZE);
        }
        this.coefficients = coefficients;
    }

    public int getNumberOfCoefficients() {
        return this.coefficients;
    }

    public void setEmbedKLTVectors(boolean embedKLTVectors) {
        this.embedKLTVectors = embedKLTVectors;
    }

    public boolean getEmbedKLTVectors() {
        return this.embedKLTVectors;
    }

    public void setBlockSize(int blockSize) throws KLTException {
        if (blockSize < 1 || blockSize > 255) {
            throw new KLTException("El tama\u00f1o del bloque debe estar entre 1 y 255");
        }
        this.BLOCK_WIDTH = blockSize;
        this.BLOCK_SIZE = blockSize * blockSize;
    }

    public int getBlockSize() {
        return this.BLOCK_WIDTH;
    }

    public void setShowBands(boolean showBands) {
        this.showBands = showBands;
    }

    public boolean getShowBands() {
        return this.showBands;
    }

    public byte[] encodeImage() throws KLTException, IOException {
        return this.encode();
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public void setOutputImageType(byte outputImageType) throws KLTException {
        switch (outputImageType) {
            case 2: 
            case 3: {
                if (this.imageType == 0) {
                    return;
                }
            }
            case 0: {
                this.outputImageType = outputImageType;
                break;
            }
            case -1: {
                this.outputImageType = this.imageType;
                break;
            }
            default: {
                throw new KLTException("Tipo de imagen de salida no soportado: " + outputImageType);
            }
        }
        if (this.outputImageType == 0) {
            this.cantBands = 1;
            if (this.imageType != 0) {
                this.setImageMatrixYCrCb();
            }
        } else {
            this.cantBands = 3;
            if (outputImageType == 3 && this.imageType != 0) {
                this.setImageMatrixYCrCb();
            }
        }
    }

    public byte getOutputImageType() {
        return this.outputImageType;
    }

    public void setKLTBaseName(String kltBaseName) {
        this.useExternalKLTBase = true;
        this.externalKLTBaseInputName = kltBaseName;
    }

    public String getKLTBaseInputName() {
        return this.externalKLTBaseInputName;
    }

    public void setKLTBaseOutputName(String externalKLTBase) {
        this.externalKLTBaseOutputName = externalKLTBase;
        this.writeExternalKLTBase = externalKLTBase != null;
    }

    public String getKLTBaseOutputName() {
        return this.externalKLTBaseOutputName;
    }

    public void encodeImage(String outputFileName) throws KLTException, IOException {
        byte[] buffer = this.encodeImage();
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFileName));
        outputStream.write(buffer);
        outputStream.close();
    }

    protected double[][] getImageMatrix(int band) {
        if (band >= this.cantBands) {
            throw new KLTException("No existe la banda " + band);
        }
        switch (this.outputImageType) {
            case 0: {
                if (this.imageType == 2) {
                    return this.imageMatrixYCrCb[band];
                }
                return this.imageMatrix[band];
            }
            case 2: {
                return this.imageMatrix[band];
            }
            case 3: {
                return this.imageMatrixYCrCb[band];
            }
        }
        throw new KLTException("Todavia no esta implementado");
    }

    private byte[] encode() throws IOException {
        this.stream = new ByteArrayOutputStream();
        this.dataStream = new DataOutputStream(this.stream);
        this.huffmanMultiplexer = new HuffmanMultiplexerBitStream();
        if (this.writeExternalKLTBase) {
            this.externalKLTWriter = new HuffmanMultiplexerBitStream();
        }
        if (this.useExternalKLTBase) {
            this.openExternalKLTBase();
        }
        this.writeHeader();
        this.compressImage();
        return this.stream.toByteArray();
    }

    private void writeHeader() throws IOException {
        this.writeString("KLT 1.0 - (u)2004, Gustavo Brown.");
        this.dataStream.writeShort(this.comment.length());
        if (this.comment.length() > 0) {
            this.writeString(this.comment);
        }
        this.dataStream.writeByte(this.getFlags());
        this.dataStream.write(this.BLOCK_WIDTH);
        this.dataStream.writeByte(this.quality);
        this.dataStream.writeShort(this.imageWidth);
        this.dataStream.writeShort(this.imageHeight);
    }

    private void compressImage() throws IOException {
        block19: {
            this.currentBand = 0;
            while (this.currentBand < this.cantBands) {
                int cantBitsNeeded;
                double value;
                int j;
                int i;
                double[][] invBasis;
                KLTHelper helper;
                if (this.useExternalKLTBase) {
                    this.currentBandLeastUsedCoeff = this.externalKLTReader.readUnencoded(16);
                    double[][] invBasis2 = new double[this.BLOCK_SIZE][this.BLOCK_SIZE];
                    int i2 = this.BLOCK_SIZE - 1;
                    while (i2 >= this.currentBandLeastUsedCoeff) {
                        int j2 = 0;
                        while (j2 < this.BLOCK_SIZE) {
                            int cantBitsNeeded2 = this.externalKLTReader.read(4);
                            invBasis2[i2][j2] = this.getDoubleFromVLI(this.externalKLTReader, cantBitsNeeded2) / 100.0;
                            ++j2;
                        }
                        --i2;
                    }
                    helper = new KLTHelper(this.BLOCK_WIDTH, this.BLOCK_SIZE, this.getImageMatrix(this.currentBand), invBasis2);
                } else {
                    helper = new KLTHelper(this.BLOCK_WIDTH, this.BLOCK_SIZE, this.getImageMatrix(this.currentBand));
                }
                this.currentBandLeastUsedCoeff = this.BLOCK_SIZE - 1;
                double[][] decodedImageMatrixCoeffs = helper.applyKLTByNumberOfCoefficients(this.getNumberOfCoefficients());
                if (this.showBands) {
                    int imageWidth = this.imageWidth;
                    int imageHeight = this.imageHeight;
                    if (this.outputImageType == 3 && this.currentBand != 0) {
                        imageWidth /= 2;
                        imageHeight /= 2;
                    }
                    PGMEncoder decodedImage = new PGMEncoder(KLTHelper.unblockRearrange(new Matrix(decodedImageMatrixCoeffs).times(helper.invEigenVectors).getArrayCopy(), imageWidth, imageHeight, this.BLOCK_WIDTH));
                    decodedImage.showImage(this.getBandName(this.currentBand));
                }
                double lastDC = 0.0;
                int i3 = 0;
                while (i3 < decodedImageMatrixCoeffs.length) {
                    if (this.showProgress) {
                        System.err.print("\rProgreso: " + (this.currentBand * decodedImageMatrixCoeffs.length + i3 + 1) * 100 / (decodedImageMatrixCoeffs.length * this.cantBands) + "%\t\t");
                    }
                    lastDC = this.encodeBlock(decodedImageMatrixCoeffs[i3], lastDC);
                    ++i3;
                }
                if (this.showProgress) {
                    System.err.println("\nLeastUsedCoeff=" + this.currentBandLeastUsedCoeff + "  ");
                }
                if (this.embedKLTVectors) {
                    this.huffmanMultiplexer.writeUnencodedBitStream(this.currentBandLeastUsedCoeff, 16);
                    invBasis = helper.getInvBasis();
                    i = this.BLOCK_SIZE - 1;
                    while (i >= this.currentBandLeastUsedCoeff) {
                        j = 0;
                        while (j < this.BLOCK_SIZE) {
                            value = invBasis[i][j] * 100.0;
                            cantBitsNeeded = this.getCantBitsNeeded(value);
                            this.huffmanMultiplexer.write(4, cantBitsNeeded);
                            this.huffmanMultiplexer.writeUnencodedBitStream(this.getVLI(cantBitsNeeded, value), cantBitsNeeded);
                            ++j;
                        }
                        --i;
                    }
                }
                if (this.writeExternalKLTBase) {
                    this.externalKLTWriter.writeUnencodedBitStream(0, 16);
                    invBasis = helper.getInvBasis();
                    i = this.BLOCK_SIZE - 1;
                    while (i >= 0) {
                        j = 0;
                        while (j < this.BLOCK_SIZE) {
                            value = invBasis[i][j] * 100.0;
                            cantBitsNeeded = this.getCantBitsNeeded(value);
                            this.externalKLTWriter.write(4, cantBitsNeeded);
                            this.externalKLTWriter.writeUnencodedBitStream(this.getVLI(cantBitsNeeded, value), cantBitsNeeded);
                            ++j;
                        }
                        --i;
                    }
                }
                ++this.currentBand;
            }
            this.huffmanMultiplexer.encodeIntoByteArray(this.stream);
            if (this.showProgress) {
                this.huffmanMultiplexer.printStatics();
            }
            if (!this.writeExternalKLTBase) break block19;
            try {
                FileOutputStream kltOutputStream = new FileOutputStream(this.externalKLTBaseOutputName);
                kltOutputStream.write("kltc".getBytes());
                kltOutputStream.write(this.BLOCK_WIDTH);
                ByteArrayOutputStream tempArray = new ByteArrayOutputStream();
                this.externalKLTWriter.encodeIntoByteArray(tempArray);
                tempArray.close();
                kltOutputStream.write(tempArray.toByteArray());
                kltOutputStream.close();
            }
            catch (IOException e) {
                System.err.println("Warning: No se pudo guardar la base de la KLT en el archivo '" + this.externalKLTBaseOutputName + "'");
                System.err.println(e.toString());
            }
        }
    }

    private double encodeBlock(double[] vector, double lastDC) {
        double currentDC;
        block5: {
            currentDC = this.quantizeDC(vector[vector.length - 1]);
            int cantBitsNeeded = this.getCantBitsNeeded(currentDC - lastDC);
            this.huffmanMultiplexer.write(4, cantBitsNeeded);
            this.huffmanMultiplexer.writeUnencodedBitStream(this.getVLI(cantBitsNeeded, currentDC - lastDC), cantBitsNeeded);
            int curCoeff = vector.length - 2;
            do {
                int cantZeros = 0;
                while (curCoeff >= 0) {
                    if (!this.isZero(this.quantizeAC(vector[curCoeff], curCoeff))) break;
                    --curCoeff;
                    ++cantZeros;
                }
                if (curCoeff == -1) {
                    this.huffmanMultiplexer.write(0 + this.currentBand, 0);
                    break block5;
                }
                if (curCoeff < this.currentBandLeastUsedCoeff) {
                    this.currentBandLeastUsedCoeff = curCoeff;
                }
                int zeroRunLength = cantZeros << 4;
                double coeffValue = this.quantizeAC(vector[curCoeff], curCoeff);
                cantBitsNeeded = this.getCantBitsNeeded(coeffValue);
                if (cantBitsNeeded > 15) {
                    throw new KLTException("Un coeficiente de alterna puede necesitar a lo sumo 15 bits para ser codificado");
                }
                this.huffmanMultiplexer.write(0 + this.currentBand, zeroRunLength | cantBitsNeeded);
                this.huffmanMultiplexer.writeUnencodedBitStream(this.getVLI(cantBitsNeeded, coeffValue), cantBitsNeeded);
            } while (--curCoeff != -1);
            this.huffmanMultiplexer.write(0 + this.currentBand, 0);
        }
        return currentDC;
    }

    private boolean isZero(double value) {
        return Math.abs(value * 200.0) <= 1.5;
    }

    private int getCantBitsNeeded(double value) {
        int integerValue;
        if (value < 0.0) {
            value = -value;
        }
        if ((integerValue = (int)Math.round(value * 200.0)) < 2) {
            integerValue = 2;
        }
        return (int)Math.ceil(Math.log(integerValue + 1) / KLTConstants.LOG_2);
    }

    private int getVLI(int cantBitsNeeded, double value) {
        int sign = 0;
        if (value < 0.0) {
            value = -value;
            sign = 1 << cantBitsNeeded - 1;
        }
        int integerValue = (int)Math.round(value * 200.0);
        return sign + integerValue - (1 << cantBitsNeeded - 1);
    }

    private byte getFlags() {
        int flags = (this.outputImageType & 3) << 1;
        return (byte)(flags |= this.embedKLTVectors ? 1 : 0);
    }

    private void writeString(String str) throws IOException {
        this.stream.write(str.getBytes());
    }

    private void setImageMatrix() {
        if (this.image instanceof BufferedImage && ((BufferedImage)this.image).getType() == 10) {
            BufferedImage image = (BufferedImage)this.image;
            this.imageType = 0;
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
            this.imageMatrix = new double[1][this.imageHeight][this.imageWidth];
            Raster raster = image.getData();
            int[] vector = new int[this.imageHeight * this.imageWidth];
            raster.getPixels(0, 0, this.imageWidth, this.imageHeight, vector);
            int k = 0;
            int j = 0;
            while (j < this.imageHeight) {
                int i = 0;
                while (i < this.imageWidth) {
                    int pixel = vector[k++];
                    this.imageMatrix[0][j][i] = pixel & 0xFF;
                    ++i;
                }
                ++j;
            }
        } else {
            Component observer = new Component(){};
            MediaTracker tracker = new MediaTracker(observer);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.imageWidth = this.image.getWidth(observer);
            this.imageHeight = this.image.getHeight(observer);
            this.imageType = (byte)2;
            this.imageMatrix = new double[3][this.imageHeight][this.imageWidth];
            int[] vector = new int[this.imageWidth * this.imageHeight];
            PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, this.imageWidth, this.imageHeight, vector, 0, this.imageWidth);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int k = 0;
            int j = 0;
            while (j < this.imageHeight) {
                int i = 0;
                while (i < this.imageWidth) {
                    int pixel = vector[k++];
                    this.imageMatrix[0][j][i] = pixel >> 16 & 0xFF;
                    this.imageMatrix[1][j][i] = pixel >> 8 & 0xFF;
                    this.imageMatrix[2][j][i] = pixel & 0xFF;
                    ++i;
                }
                ++j;
            }
        }
    }

    private void setImageMatrixYCrCb() {
        double[][][] tempImageYCrCb = KLTHelper.convertToYCrCb(this.imageMatrix);
        this.imageMatrixYCrCb = new double[3][][];
        this.imageMatrixYCrCb[0] = tempImageYCrCb[0];
        int subsampledHeight = (this.imageHeight + 2 - 1) / 2;
        int subsampledWidth = (this.imageWidth + 2 - 1) / 2;
        this.imageMatrixYCrCb[1] = new double[subsampledHeight][subsampledWidth];
        this.imageMatrixYCrCb[2] = new double[subsampledHeight][subsampledWidth];
        int curY = 0;
        int j = 0;
        while (j < this.imageHeight) {
            int curX = 0;
            int i = 0;
            while (i < this.imageWidth) {
                double mediumValueCr = 0.0;
                double mediumValueCb = 0.0;
                int cantValues = 0;
                int _j = 0;
                while (_j < 2) {
                    int _i = 0;
                    while (_i < 2) {
                        try {
                            mediumValueCr += tempImageYCrCb[1][j + _j][i + _i];
                            mediumValueCb += tempImageYCrCb[2][j + _j][i + _i];
                            ++cantValues;
                        }
                        catch (ArrayIndexOutOfBoundsException outOfBounds) {
                            // empty catch block
                        }
                        ++_i;
                    }
                    ++_j;
                }
                this.imageMatrixYCrCb[1][curY][curX] = mediumValueCr / (double)cantValues;
                this.imageMatrixYCrCb[2][curY][curX++] = mediumValueCb / (double)cantValues;
                i += 2;
            }
            ++curY;
            j += 2;
        }
    }

    private String getBandName(int band) {
        switch (this.outputImageType) {
            case 0: {
                return "Canal Gris";
            }
            case 2: {
                return "Canal " + (band == 0 ? "R" : (band == 1 ? "G" : "B"));
            }
            case 3: {
                return "Canal " + (band == 0 ? "Y" : (band == 1 ? "Cr" : "Cb"));
            }
        }
        return "Desconocido";
    }

    private double quantizeDC(double value) {
        return value / 10.0;
    }

    private double quantizeAC(double value, int curCoef) {
        if (this.outputImageType == 3 && this.currentBand != 0) {
            return value / 200000.0 * (double)this.quality * Math.pow(1.01, curCoef);
        }
        return value / 80000.0 * (double)this.quality * Math.pow(1.01, curCoef);
    }

    private double dequantizeDC(double value) {
        return value * 10.0;
    }

    private double dequantizeAC(double value, int curCoef) {
        if (this.imageType == 3 && this.currentBand != 0) {
            return value * 200000.0 / (Math.pow(1.01, curCoef) * (double)this.quality);
        }
        return value * 80000.0 / (Math.pow(1.01, curCoef) * (double)this.quality);
    }

    private double getDoubleFromVLI(HuffmanMultiplexerBitInputStream huffmanDecoder, int cantBitsNeeded) throws IOException {
        int cte;
        int value = huffmanDecoder.readUnencoded(cantBitsNeeded);
        boolean isNegative = (value & (cte = 1 << cantBitsNeeded - 1)) != 0;
        value &= ~cte;
        boolean sign = false;
        value += cte;
        if (isNegative) {
            value = -value;
        }
        return (double)value / 200.0;
    }

    private void openExternalKLTBase() throws IOException {
        BufferedInputStream kltInputStream = new BufferedInputStream(new FileInputStream(this.externalKLTBaseInputName));
        byte[] tempBuffer = new byte[4];
        kltInputStream.read(tempBuffer);
        if (!new String(tempBuffer).equals("kltc")) {
            throw new KLTException("Archivo de coeficientes de la base de la KLT inv\u00e1lido (" + this.externalKLTBaseInputName + ")");
        }
        int embededBlockWidth = kltInputStream.read() & 0xFF;
        if (embededBlockWidth != this.BLOCK_WIDTH) {
            System.err.println("Warning: El archivo de coeficientes difiere en el tama\u00f1o del bloque");
            System.err.println("         Se utilizara como valor " + embededBlockWidth + " en vez de " + this.BLOCK_WIDTH);
            this.setBlockSize(embededBlockWidth);
        }
        this.externalKLTReader = new HuffmanMultiplexerBitInputStream(kltInputStream);
    }
}

