/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        int i = 0;
        while (i < this.m) {
            this.piv[i] = i;
            ++i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        int j = 0;
        while (j < this.n) {
            int k;
            int i2 = 0;
            while (i2 < this.m) {
                LUcolj[i2] = this.LU[i2][j];
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.m) {
                double[] LUrowi = this.LU[i3];
                int kmax = Math.min(i3, j);
                double s = 0.0;
                k = 0;
                while (k < kmax) {
                    s += LUrowi[k] * LUcolj[k];
                    ++k;
                }
                int n = i3++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            int i4 = j + 1;
            while (i4 < this.m) {
                if (Math.abs(LUcolj[i4]) > Math.abs(LUcolj[p])) {
                    p = i4;
                }
                ++i4;
            }
            if (p != j) {
                int k2 = 0;
                while (k2 < this.n) {
                    double t = this.LU[p][k2];
                    this.LU[p][k2] = this.LU[j][k2];
                    this.LU[j][k2] = t;
                    ++k2;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j < this.m & this.LU[j][j] != 0.0) {
                int i5 = j + 1;
                while (i5 < this.m) {
                    double[] dArray = this.LU[i5];
                    int n = j;
                    dArray[n] = dArray[n] / this.LU[j][j];
                    ++i5;
                }
            }
            ++j;
        }
    }

    public boolean isNonsingular() {
        int j = 0;
        while (j < this.n) {
            if (this.LU[j][j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getArray();
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
                ++j;
            }
            ++i;
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        int i = 0;
        while (i < this.m) {
            p[i] = this.piv[i];
            ++i;
        }
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        int i = 0;
        while (i < this.m) {
            vals[i] = this.piv[i];
            ++i;
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n) {
            d *= this.LU[j][j];
            ++j;
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        int k = 0;
        while (k < this.n) {
            int i = k + 1;
            while (i < this.n) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        int k2 = this.n - 1;
        while (k2 >= 0) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k2];
                int n = j++;
                dArray[n] = dArray[n] / this.LU[k2][k2];
            }
            int i = 0;
            while (i < k2) {
                int j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k2][j2] * this.LU[i][k2];
                    ++j2;
                }
                ++i;
            }
            --k2;
        }
        return Xmat;
    }
}

