/*
 * Decompiled with CFR 0.152.
 */
import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.brownsoft.image.PGMDecoder;
import com.brownsoft.image.PGMEncoder;

public class KLImage3 {
    public int BLOCK_WIDTH = 8;
    public int cantVectors = 11;

    public static void main(String[] args) {
        block4: {
            try {
                KLImage3 klImage = new KLImage3();
                if (args.length != 0) {
                    if (args.length > 1) {
                        klImage.cantVectors = Integer.parseInt(args[1]);
                    }
                    klImage.process(args[0]);
                    break block4;
                }
                klImage.process("house.pgm");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public double[][] blockRearrange(double[][] imageMatrix) {
        int pixelsWidth = imageMatrix[0].length;
        int pixelsHeight = imageMatrix.length;
        int blocksWidth = (int)Math.ceil((double)pixelsWidth / (double)this.BLOCK_WIDTH);
        int blocksHeight = (int)Math.ceil((double)pixelsHeight / (double)this.BLOCK_WIDTH);
        double[][] matrixNbyM = new double[blocksHeight * blocksWidth][this.BLOCK_WIDTH * this.BLOCK_WIDTH];
        int k = 0;
        int j = 0;
        while (j < blocksHeight) {
            int i = 0;
            while (i < blocksWidth) {
                matrixNbyM[k++] = this.getBlockAsVector(imageMatrix, i, j);
                ++i;
            }
            ++j;
        }
        return matrixNbyM;
    }

    public double[] getBlockAsVector(double[][] imageMatrix, int x, int y) {
        double[] vector = new double[this.BLOCK_WIDTH * this.BLOCK_WIDTH];
        int k = 0;
        y *= this.BLOCK_WIDTH;
        int _x = x *= this.BLOCK_WIDTH;
        int j = 0;
        while (j < this.BLOCK_WIDTH) {
            int i = 0;
            while (i < this.BLOCK_WIDTH) {
                vector[k++] = imageMatrix[y][x];
                if (x < imageMatrix[0].length) {
                    ++x;
                }
                ++i;
            }
            if (y < imageMatrix.length) {
                ++y;
            }
            x = _x;
            ++j;
        }
        return vector;
    }

    public double[][] unblockRearrange(double[][] imageMatrix, int pixelsWidth, int pixelsHeight) {
        double[][] matrix = new double[pixelsHeight][pixelsWidth];
        int blocksWidth = (int)Math.ceil((double)pixelsWidth / (double)this.BLOCK_WIDTH);
        int blocksHeight = (int)Math.ceil((double)pixelsHeight / (double)this.BLOCK_WIDTH);
        int k = 0;
        int y = 0;
        int j = 0;
        while (j < blocksHeight) {
            int _y = y;
            int x = 0;
            int i = 0;
            while (i < blocksWidth) {
                double[] block = imageMatrix[k++];
                y = _y;
                int _x = x;
                int blockJ = 0;
                while (blockJ < this.BLOCK_WIDTH) {
                    x = _x;
                    int blockI = 0;
                    while (blockI < this.BLOCK_WIDTH) {
                        matrix[y][x++] = block[blockJ * this.BLOCK_WIDTH + blockI];
                        if (x == pixelsWidth) break;
                        ++blockI;
                    }
                    if (++y == pixelsHeight) break;
                    ++blockJ;
                }
                ++i;
            }
            ++j;
        }
        return matrix;
    }

    public Matrix pruneEigenVectors(Matrix eigenVectors, int cantToLeave) {
        Matrix matrix = new Matrix(eigenVectors.getArrayCopy());
        int size = eigenVectors.getColumnDimension();
        int cantToPrune = size - cantToLeave;
        matrix.setMatrix(0, cantToPrune - 1, 0, size - 1, new Matrix(cantToPrune, size));
        return matrix;
    }

    public Matrix cov(Matrix inputMatrix) {
        int m = inputMatrix.getRowDimension();
        int n = inputMatrix.getColumnDimension();
        Matrix X = new Matrix(n, n);
        int degrees = m - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                int k = 0;
                while (k < m) {
                    s1 += inputMatrix.get(k, i);
                    s2 += inputMatrix.get(k, j);
                    ++k;
                }
                s1 /= (double)m;
                s2 /= (double)m;
                int k2 = 0;
                while (k2 < m) {
                    c += (inputMatrix.get(k2, i) - s1) * (inputMatrix.get(k2, j) - s2);
                    ++k2;
                }
                X.set(i, j, c / (double)degrees);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public void process(String file) throws Exception {
        PGMDecoder decoder = new PGMDecoder(file);
        decoder.showImage();
        double[][] imageMatrix = decoder.getMatrix();
        int imageWidth = imageMatrix[0].length;
        int imageHeight = imageMatrix.length;
        double[][] imageMatrixCoeffs = this.blockRearrange(imageMatrix);
        Matrix pcaMatrix = new Matrix(imageMatrixCoeffs);
        Matrix covariance = this.cov(pcaMatrix);
        EigenvalueDecomposition evd = covariance.eig();
        Matrix eigenVectors = evd.getV();
        Matrix eigenValues = evd.getD();
        eigenValues.print(eigenValues.getColumnDimension(), eigenValues.getRowDimension());
        Matrix invEigenVectors = eigenVectors.inverse();
        Matrix kltImage = pcaMatrix.times(eigenVectors);
        Matrix invEigenVectorsPrunned = this.pruneEigenVectors(invEigenVectors, this.cantVectors);
        Matrix kltDecodedImage = kltImage.times(invEigenVectorsPrunned);
        double[][] decodedImageMatrixCoeffs = this.unblockRearrange(kltDecodedImage.getArrayCopy(), imageWidth, imageHeight);
        PGMEncoder decodedImage = new PGMEncoder(decodedImageMatrixCoeffs);
        decodedImage.showImage(file);
    }
}

