/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import com.brownsoft.codec.KLTException;
import java.io.IOException;
import java.io.InputStream;

public class HuffmanMultiplexerBitInputStream {
    public static boolean DEBUG = false;
    private int curByte = 0;
    private int nextCurByte;
    private int nextNextCurByte;
    private byte curPos = 0;
    private static final int UNENCODED = -2147483647;
    private static final int MAX_CHANNELS = 5;
    private static final double LOG_2 = Math.log(2.0);
    private FSMNode[] ROOTs = new FSMNode[5];
    private InputStream stream;
    private int elementsLeft;
    private static final StringBuffer NO_DEBUG = new StringBuffer("{Para ver el simbolo setear la constante DEBUG en true}");

    public HuffmanMultiplexerBitInputStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.elementsLeft = (int)this.readBitStream(32);
        this.readDictionaries();
    }

    public int readUnencoded(int cantBits) throws IOException {
        if (this.elementsLeft-- <= 0) {
            throw new KLTException("Se ha intentado leer m\u00e1s simbolos de los que contiene el stream");
        }
        return (int)this.readBitStream(cantBits);
    }

    public int read(int channel) throws IOException {
        if (this.elementsLeft-- <= 0) {
            throw new KLTException("Se ha intentado leer m\u00e1s simbolos de los que contiene el stream");
        }
        return this.decode(this.ROOTs[channel]);
    }

    private int decode(FSMNode ROOT) throws IOException {
        boolean bit;
        StringBuffer decodedString = DEBUG ? new StringBuffer() : NO_DEBUG;
        FSMNode node = ROOT;
        do {
            bit = this.readBit();
            if (DEBUG) {
                decodedString.append(bit ? "1" : "0");
            }
            if (node.exists(bit)) continue;
            throw new IOException("No se pudo decodificar la entrada '" + decodedString.toString() + "'");
        } while (!(node = node.get(bit)).isValid());
        return node.getSymbol();
    }

    private void readDictionaries() throws IOException {
        int i = 0;
        while (i < 5) {
            this.ROOTs[i] = new FSMNode();
            if (this.readBit()) {
                this.readDictionary(this.ROOTs[i]);
            }
            ++i;
        }
    }

    private void readDictionary(FSMNode ROOT) throws IOException {
        int cantSymbols = (int)this.readBitStream(16);
        int maxBitsPerSymbol = this.getCantBitsNeeded(cantSymbols);
        int i = 0;
        while (i < cantSymbols) {
            int cantBytesThisSymbol = (int)this.readBitStream(2) + 1;
            int symbol = (int)this.readBitStream(8 * cantBytesThisSymbol);
            int size = (int)this.readBitStream(maxBitsPerSymbol);
            this.addFsmNode(ROOT, symbol, size);
            ++i;
        }
    }

    private void addFsmNode(FSMNode node, int symbol, int left) throws IOException {
        if (left == 1) {
            node.set(this.readBit(), new FSMNode(symbol));
        } else {
            this.addFsmNode(node.get(this.readBit()), symbol, left - 1);
        }
    }

    private int getCantBitsNeeded(int size) {
        return (int)Math.ceil(Math.log(size + 1) / LOG_2);
    }

    private boolean readBit() throws IOException {
        byte by = this.curPos;
        this.curPos = (byte)(by + 1);
        if (by == 0) {
            this.curByte = this.stream.read();
        }
        this.curPos = (byte)(this.curPos % 8);
        boolean bit = (this.curByte & 1) == 1;
        this.curByte >>= 1;
        return bit;
    }

    private long readBitStream(int size) throws IOException {
        long retValue = 0L;
        int i = 0;
        while (i < size) {
            retValue |= (long)((this.readBit() ? 1 : 0) << i);
            ++i;
        }
        return retValue;
    }

    class FSMNode {
        private boolean isValid = false;
        private int symbol;
        private FSMNode node0 = null;
        private FSMNode node1 = null;

        public FSMNode() {
        }

        public FSMNode(int symbol) {
            this.isValid = true;
            this.symbol = symbol;
        }

        public FSMNode get(boolean bit) {
            if (bit) {
                return this.get1();
            }
            return this.get0();
        }

        public FSMNode get0() {
            if (this.node0 == null) {
                this.node0 = new FSMNode();
            }
            return this.node0;
        }

        public FSMNode get1() {
            if (this.node1 == null) {
                this.node1 = new FSMNode();
            }
            return this.node1;
        }

        public void set(boolean bit, FSMNode node) {
            if (bit) {
                this.set1(node);
            } else {
                this.set0(node);
            }
        }

        public void set0(FSMNode node) {
            if (this.node0 != null) {
                throw new IllegalArgumentException("Error al crear la maquina de estados finitos");
            }
            this.node0 = node;
        }

        public void set1(FSMNode node) {
            if (this.node1 != null) {
                throw new IllegalArgumentException("Error al crear la maquina de estados finitos");
            }
            this.node1 = node;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public boolean exists(boolean bit) {
            if (bit) {
                return this.node1 != null;
            }
            return this.node0 != null;
        }
    }
}

