/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import com.brownsoft.codec.HuffmanEncoder;
import com.brownsoft.codec.HuffmanNode;
import com.brownsoft.codec.KLTException;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class HuffmanMultiplexerBitStream {
    private int[] channelWrites;
    private Vector streamData = new Vector();
    private HuffmanEncoder[] encoders;
    public static final int UNENCODED = -2147483647;
    public static final int MAX_CHANNELS = 5;
    private ByteArrayOutputStream stream;
    private byte curByte = 0;
    private byte curPos = 0;
    private static final double LOG_2 = Math.log(2.0);

    public HuffmanMultiplexerBitStream() {
        this.channelWrites = new int[5];
    }

    public void encodeIntoByteArray(ByteArrayOutputStream stream) {
        if (this.encoders == null) {
            this.setDictionaries();
        }
        this.stream = stream;
        this.curByte = 0;
        this.curPos = 0;
        this.writeBitStream(this.streamData.size(), 32);
        this.writeDictionaries();
        Enumeration enumeration = this.streamData.elements();
        while (enumeration.hasMoreElements()) {
            StreamData streamData = (StreamData)enumeration.nextElement();
            int channel = streamData.channel;
            if (channel == -2147483647) {
                this.writeBitStream(streamData.data, (int)streamData.size);
                continue;
            }
            HuffmanNode node = this.encoders[channel].encode(streamData.data);
            this.writeBitStream(node.getNode(), node.getSize());
        }
        if (this.curPos != 0) {
            stream.write(this.curByte);
        }
    }

    public int getCantObjectsWritten() {
        return this.streamData.size();
    }

    public void writeUnencodedBitStream(int data, int size) {
        this.streamData.addElement(new StreamData(-2147483647, data, size));
    }

    public void write(int channel, int data) {
        this.streamData.addElement(new StreamData(channel, data));
        int n = channel;
        this.channelWrites[n] = this.channelWrites[n] + 1;
    }

    public void setDictionaries() {
        this.encoders = new HuffmanEncoder[5];
        int[][] datas = new int[5][];
        int i = 0;
        while (i < 5) {
            datas[i] = new int[this.channelWrites[i]];
            this.channelWrites[i] = 0;
            ++i;
        }
        Enumeration enumeration = this.streamData.elements();
        while (enumeration.hasMoreElements()) {
            StreamData streamData = (StreamData)enumeration.nextElement();
            int channel = streamData.channel;
            if (channel == -2147483647) continue;
            int n = channel;
            int n2 = this.channelWrites[n];
            this.channelWrites[n] = n2 + 1;
            datas[channel][n2] = streamData.data;
        }
        int i2 = 0;
        while (i2 < 5) {
            this.encoders[i2] = new HuffmanEncoder(datas[i2]);
            ++i2;
        }
    }

    public void printStatics() {
        if (this.encoders == null) {
            this.setDictionaries();
        }
        int i = 0;
        while (i < 5) {
            if (this.encoders[i].isValid()) {
                System.err.println();
                System.err.println("Fuente " + i);
                this.encoders[i].printDictionary();
                System.err.println("Entropia de la fuente " + this.encoders[i].getSourceEntropy());
            }
            ++i;
        }
        System.err.println();
        System.err.println("Cantidad de objetos embebidos: " + this.getCantObjectsWritten());
    }

    private int getCantBitsNeeded(int size) {
        return (int)Math.ceil(Math.log(size + 1) / LOG_2);
    }

    private void writeBitStream(long data, int size) {
        int i = 0;
        while (i < size) {
            this.curByte = (byte)((long)this.curByte | (data & 1L) << this.curPos);
            data >>= 1;
            this.curPos = (byte)(this.curPos + 1);
            if (this.curPos == 8) {
                this.stream.write(this.curByte);
                this.curPos = 0;
                this.curByte = 0;
            }
            ++i;
        }
    }

    private void writeBitStream(long[] data, int size) {
        int i = 0;
        while (i < data.length) {
            this.writeBitStream(data[i], size > 64 ? 64 : size);
            size -= 64;
            ++i;
        }
    }

    private void finishStream() {
        if (this.curPos != 0) {
            this.stream.write(this.curByte);
        }
        this.stream = null;
    }

    private void writeDictionaries() {
        int i = 0;
        while (i < 5) {
            if (this.encoders[i].isValid()) {
                this.writeBitStream(1L, 1);
                this.writeDictionary(this.encoders[i]);
            } else {
                this.writeBitStream(0L, 1);
            }
            ++i;
        }
    }

    private void writeDictionary(HuffmanEncoder encoder) {
        short cantSymbols = (short)encoder.getCantSymbols();
        if (cantSymbols > 65536) {
            throw new KLTException("Puede haber como m\u00e1ximo 65536 simbolos");
        }
        this.writeBitStream(cantSymbols, 16);
        int maxBitsPerSymbol = this.getCantBitsNeeded(cantSymbols);
        if (maxBitsPerSymbol == 0) {
            ++maxBitsPerSymbol;
        }
        HuffmanNode[] symbols = encoder.getSymbols();
        int i = 0;
        while (i < symbols.length) {
            int symbol = symbols[i].getSymbol();
            int N = 0;
            if (symbol > 0) {
                N = this.getCantBitsNeeded(symbol) / 8;
            }
            this.writeBitStream(N, 2);
            this.writeBitStream(symbols[i].getSymbol(), (N + 1) * 8);
            this.writeBitStream(symbols[i].getSize(), maxBitsPerSymbol);
            this.writeBitStream(symbols[i].getNode(), symbols[i].getSize());
            ++i;
        }
    }

    class StreamData {
        public int channel;
        public int data;
        public byte size;

        public StreamData(int channel, int data, int size) {
            this.channel = channel;
            this.data = data;
            this.size = (byte)size;
        }

        public StreamData(int channel, int data) {
            this.channel = channel;
            this.data = data;
            this.size = (byte)-1;
        }
    }
}

