/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.image;

import com.brownsoft.image.ImageCanvas;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PGMDecoder {
    private int width;
    private int height;
    private DataInputStream inputStream;
    private int[] buffer;
    private double[][] matrix;
    protected String ImageType;
    protected String HeaderId;
    protected int BandCount;
    protected int ColorType;
    protected String filename;

    public PGMDecoder(InputStream stream, String ImageType, String HeaderId, int BandCount, int ColorType) throws IOException {
        this.inputStream = new DataInputStream(new BufferedInputStream(stream));
        this.ImageType = ImageType;
        this.HeaderId = HeaderId;
        this.BandCount = BandCount;
        this.ColorType = ColorType;
    }

    public PGMDecoder(InputStream stream) throws IOException {
        this(stream, "PGM", "P5", 1, 10);
    }

    public PGMDecoder(String filename) throws IOException {
        this(new FileInputStream(filename));
        this.filename = filename;
    }

    public int[] getVector() throws IOException {
        if (this.buffer != null) {
            return this.buffer;
        }
        String imageType = this.getLine();
        if (!imageType.equalsIgnoreCase(this.HeaderId)) {
            throw new IOException("Header inv\u00e1lido: La imagen no es del tipo " + this.ImageType);
        }
        String imageSize = this.getLine();
        int index = imageSize.indexOf(" ");
        if (index == -1) {
            throw new IOException("Header inv\u00e1lido: No se puede determinar el tama\u00f1o de la imagen");
        }
        this.width = Integer.parseInt(imageSize.substring(0, index));
        this.height = Integer.parseInt(imageSize.substring(index + 1));
        String pixelRange = this.getLine();
        if (Integer.parseInt(pixelRange) != 255) {
            throw new IOException("Solo se puede decodificar imagenes de 8 bpp");
        }
        byte[] bytes = new byte[this.width * this.height * this.BandCount];
        this.inputStream.readFully(bytes);
        this.buffer = new int[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            this.buffer[i] = bytes[i] > 0 ? bytes[i] : bytes[i] + 128 + 128;
            ++i;
        }
        this.inputStream.close();
        return this.buffer;
    }

    public double[][] getMatrix() {
        if (this.matrix != null) {
            return this.matrix;
        }
        this.matrix = new double[this.height][this.width];
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                this.matrix[j][i] = this.buffer[k++];
                ++i;
            }
            ++j;
        }
        return this.matrix;
    }

    public Image getImage() throws IOException {
        int[] buffer = this.getVector();
        BufferedImage image = new BufferedImage(this.width, this.height, this.ColorType);
        WritableRaster raster = image.getRaster();
        raster.setPixels(0, 0, this.width, this.height, buffer);
        return image;
    }

    private String getLine() throws IOException {
        String line;
        do {
            if ((line = this.inputStream.readLine().trim()) != null) continue;
            throw new IOException("Formato inv\u00e1lido");
        } while (line.startsWith("#"));
        return line;
    }

    public void showImage() {
        try {
            Frame frame = new Frame("PGMDecoder (u)2004, Gustavo Brown" + (this.filename != null ? " - '" + this.filename + "'" : ""));
            frame.add(new ImageCanvas(this.getImage()));
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    evt.getWindow().dispose();
                }
            });
            frame.pack();
            frame.show();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.err.println("PGMDecoder, (u)2004, Gustavo Brown");
        System.err.println();
        if (args.length < 1) {
            System.err.println("Argumento: Nombre de archivo .pgm");
            return;
        }
        try {
            String file = args[0];
            Frame frame = new Frame("PGMDecoder (u)2004, Gustavo Brown - '" + file + "'");
            frame.add(new ImageCanvas(new PGMDecoder(file).getImage()));
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.show();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

