/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import com.brownsoft.codec.HuffmanNode;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;

public class HuffmanEncoder {
    protected static final int MAX_SYMBOL_SIZE = 256;
    private Hashtable nodes;
    private int cantSymbols = 0;
    HuffmanNode[] symbols = null;

    public void HuffmanEncoder() {
    }

    public HuffmanEncoder(int[] sourceDictionary) {
        this.setSourceDictionary(sourceDictionary);
    }

    public void setSourceDictionary(int[] sourceDictionary) {
        int size = sourceDictionary.length;
        Hashtable<Integer, int[]> freqs = new Hashtable<Integer, int[]>();
        int i = 0;
        while (i < sourceDictionary.length) {
            Integer value = new Integer(sourceDictionary[i]);
            int[] thisFreq = (int[])freqs.get(value);
            if (thisFreq == null) {
                thisFreq = new int[]{1};
                freqs.put(value, thisFreq);
            } else {
                thisFreq[0] = thisFreq[0] + 1;
            }
            ++i;
        }
        this.nodes = new Hashtable();
        int diffSymbols = freqs.size();
        HuffmanNode[] tempProps = new HuffmanNode[diffSymbols];
        int j = 0;
        Enumeration enumeration = freqs.keys();
        while (enumeration.hasMoreElements()) {
            Integer value = (Integer)enumeration.nextElement();
            int thisFreq = ((int[])freqs.get(value))[0];
            tempProps[j] = new HuffmanNode(value, (double)thisFreq / (double)size);
            this.nodes.put(value, tempProps[j]);
            ++j;
        }
        this.cantSymbols = diffSymbols;
        if (diffSymbols == 0) {
            return;
        }
        int curSymbols = diffSymbols;
        while (curSymbols > 1) {
            this.sort(tempProps, curSymbols);
            tempProps[curSymbols - 2] = new HuffmanNode(tempProps[curSymbols - 2], tempProps[curSymbols - 1]);
            --curSymbols;
        }
        tempProps[0].setNode(new long[0], 0);
        this.symbols = new HuffmanNode[diffSymbols];
        j = 0;
        Enumeration enum2 = this.nodes.elements();
        while (enum2.hasMoreElements()) {
            this.symbols[j] = (HuffmanNode)enum2.nextElement();
            ++j;
        }
    }

    private void sort(HuffmanNode[] nodes, int size) {
        boolean swapped = false;
        int i = size - 1;
        while (i > 0) {
            int j = i;
            while (j > 0) {
                if (nodes[j].getProbability() > nodes[j - 1].getProbability()) {
                    HuffmanNode tempNode = nodes[j];
                    nodes[j] = nodes[j - 1];
                    nodes[j - 1] = tempNode;
                    swapped = true;
                }
                --j;
            }
            if (!swapped) break;
            --i;
        }
    }

    public void printDictionary() {
        if (this.symbols == null) {
            return;
        }
        int i = 0;
        while (i < this.symbols.length) {
            System.out.println(this.symbols[i].toString());
            ++i;
        }
    }

    public int getCantSymbols() {
        return this.cantSymbols;
    }

    public HuffmanNode[] getSymbols() {
        return this.symbols;
    }

    public HuffmanNode encode(int symbol) throws IllegalArgumentException {
        if (this.nodes == null) {
            throw new IllegalArgumentException("No se ha definido diccionario para esta instancia de HuffmanEncoder");
        }
        HuffmanNode encoder = (HuffmanNode)this.nodes.get(new Integer(symbol));
        if (encoder == null || !encoder.isValid()) {
            throw new IllegalArgumentException("El diccionario no contiene una entrada para el s\u00edmbolo 0x" + Integer.toHexString(symbol));
        }
        return encoder;
    }

    public double getSourceEntropy() {
        BigDecimal entropia = new BigDecimal(0.0);
        BigDecimal log2 = new BigDecimal(Math.log(2.0));
        int i = 0;
        while (i < this.symbols.length) {
            BigDecimal thisSymbol = new BigDecimal(this.symbols[i].getProbability());
            entropia = entropia.subtract(thisSymbol.multiply(new BigDecimal(Math.log(thisSymbol.doubleValue())).divide(log2, 0)));
            ++i;
        }
        return entropia.doubleValue();
    }

    public boolean isValid() {
        return this.symbols != null;
    }

    public int getCantBitsMaxCodeword() {
        int cantBitsMaxCodeword = 0;
        int i = 0;
        while (i < this.symbols.length) {
            int cantBits = this.symbols[i].getSize();
            if (cantBits > cantBitsMaxCodeword) {
                cantBitsMaxCodeword = cantBits;
            }
            ++i;
        }
        return cantBitsMaxCodeword;
    }
}

