/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

public class HuffmanNode {
    private long[] nodeStream;
    private int size;
    private double probability;
    private HuffmanNode node1;
    private HuffmanNode node2;
    private boolean isComplex = false;
    private int symbol;
    private boolean isValid = false;

    public HuffmanNode(int symbol, double probability) {
        this.symbol = symbol;
        this.probability = probability;
        this.size = -1;
    }

    public HuffmanNode(HuffmanNode node1, HuffmanNode node2) {
        this.probability = node1.getProbability() + node2.getProbability();
        this.node1 = node1;
        this.node2 = node2;
        this.isComplex = true;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setNode(long[] node, int size) {
        if (this.isValid) {
            throw new Error("Este nodo ya tiene una codeword asociada: " + this.toString());
        }
        if (this.isComplex) {
            int pos = size % 64;
            if (pos == 0) {
                long[] newNode = new long[node.length + 1];
                System.arraycopy(node, 0, newNode, 0, node.length);
                node = newNode;
            }
            long[] nodeStream1 = (long[])node.clone();
            long[] nodeStream2 = (long[])node.clone();
            int n = node.length - 1;
            nodeStream2[n] = nodeStream2[n] | (long)(1 << pos);
            this.node1.setNode(nodeStream1, ++size);
            this.node2.setNode(nodeStream2, size);
        } else {
            if (size == 0) {
                ++size;
                node = new long[]{0L};
            }
            this.nodeStream = node;
            this.size = size;
            this.isValid = true;
        }
    }

    public int getSymbol() {
        return this.symbol;
    }

    public long[] getNode() {
        return this.nodeStream;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        String ret = Integer.toHexString(this.symbol) + " [prob=" + this.ensure20(this.getProbability()) + "]: ";
        int idx = this.size / 64;
        int pos = this.size % 64;
        int i = 0;
        while (i <= idx) {
            long node = this.nodeStream[i];
            while (pos > 0) {
                ret = ret + (node & 1L);
                node >>= 1;
                --pos;
            }
            pos = 64;
            ++i;
        }
        return ret;
    }

    private String ensure20(double value) {
        String retVal = Double.toString(value);
        while (retVal.length() < 20) {
            retVal = retVal + "0";
        }
        return retVal;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

