/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.codec;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;

public class KLTHelper {
    private int imageWidth;
    private int imageHeight;
    public Matrix eigenVectors;
    public Matrix invEigenVectors;
    public Matrix eigenValues;
    public Matrix pcaMatrix;
    private int BLOCK_WIDTH;
    private int BLOCK_SIZE;
    private double[][] imageMatrix;
    private static final double[][] RGBToYCrCbMatrix = new double[][]{{0.289, 0.587, 0.114}, {-0.1687, -0.3313, 0.5}, {0.5, -0.4187, -0.0813}};
    private static final double[][] YCrCbToRGBMatrix = new double[][]{{1.009, 0.0, 1.417}, {1.011, -0.344, -0.701}, {1.01, 1.772, 0.0015}};

    public KLTHelper(int BLOCK_WIDTH, int BLOCK_SIZE, double[][] imageMatrix) {
        this.BLOCK_WIDTH = BLOCK_WIDTH;
        this.BLOCK_SIZE = BLOCK_SIZE;
        this.imageMatrix = imageMatrix;
        this.initialize();
    }

    public KLTHelper(int BLOCK_WIDTH, int BLOCK_SIZE, double[][] imageMatrix, double[][] invBasis) {
        this.BLOCK_WIDTH = BLOCK_WIDTH;
        this.BLOCK_SIZE = BLOCK_WIDTH * BLOCK_WIDTH;
        this.imageMatrix = imageMatrix;
        double[][] imageMatrixCoeffs = this.blockRearrange(imageMatrix);
        this.pcaMatrix = new Matrix(imageMatrixCoeffs);
        this.invEigenVectors = new Matrix(invBasis);
        this.eigenVectors = this.invEigenVectors.inverse();
    }

    public double[][] blockRearrange(double[][] imageMatrix) {
        int pixelsWidth = imageMatrix[0].length;
        int pixelsHeight = imageMatrix.length;
        int blocksWidth = (int)Math.ceil((double)pixelsWidth / (double)this.BLOCK_WIDTH);
        int blocksHeight = (int)Math.ceil((double)pixelsHeight / (double)this.BLOCK_WIDTH);
        double[][] matrixNbyM = new double[blocksHeight * blocksWidth][this.BLOCK_SIZE];
        int k = 0;
        int j = 0;
        while (j < blocksHeight) {
            int i = 0;
            while (i < blocksWidth) {
                matrixNbyM[k++] = this.getBlockAsVector(imageMatrix, i, j);
                ++i;
            }
            ++j;
        }
        return matrixNbyM;
    }

    public double[] getBlockAsVector(double[][] imageMatrix, int x, int y) {
        double[] vector = new double[this.BLOCK_SIZE];
        int k = 0;
        y *= this.BLOCK_WIDTH;
        int _x = x *= this.BLOCK_WIDTH;
        int j = 0;
        while (j < this.BLOCK_WIDTH) {
            int i = 0;
            while (i < this.BLOCK_WIDTH) {
                vector[k++] = imageMatrix[y][x];
                if (x < imageMatrix[0].length - 1) {
                    ++x;
                }
                ++i;
            }
            if (y < imageMatrix.length - 1) {
                ++y;
            }
            x = _x;
            ++j;
        }
        return vector;
    }

    public static double[][] unblockRearrange(double[][] imageMatrix, int pixelsWidth, int pixelsHeight, int BLOCK_WIDTH) {
        double[][] matrix = new double[pixelsHeight][pixelsWidth];
        int blocksWidth = (int)Math.ceil((double)pixelsWidth / (double)BLOCK_WIDTH);
        int blocksHeight = (int)Math.ceil((double)pixelsHeight / (double)BLOCK_WIDTH);
        int k = 0;
        int y = 0;
        int j = 0;
        while (j < blocksHeight) {
            int _y = y;
            int x = 0;
            int i = 0;
            while (i < blocksWidth) {
                double[] block = imageMatrix[k++];
                y = _y;
                int _x = x;
                int blockJ = 0;
                while (blockJ < BLOCK_WIDTH) {
                    x = _x;
                    int blockI = 0;
                    while (blockI < BLOCK_WIDTH) {
                        matrix[y][x++] = block[blockJ * BLOCK_WIDTH + blockI];
                        if (x == pixelsWidth) break;
                        ++blockI;
                    }
                    if (++y == pixelsHeight) break;
                    ++blockJ;
                }
                ++i;
            }
            ++j;
        }
        return matrix;
    }

    public Matrix pruneEigenVectors(Matrix vectors, int cantToLeave) {
        Matrix matrix = new Matrix(this.eigenVectors.getArrayCopy());
        int size = this.eigenVectors.getColumnDimension();
        int cantToPrune = size - cantToLeave;
        matrix.setMatrix(0, cantToPrune - 1, 0, size - 1, new Matrix(cantToPrune, size));
        return matrix;
    }

    public void pruneCoeffs(double[][] matrix, int cantToLeave) {
        int size = matrix.length;
        int cantToPrune = this.BLOCK_SIZE - cantToLeave;
        double[] zeros = new double[cantToPrune];
        int i = 0;
        while (i < size) {
            System.arraycopy(zeros, 0, matrix[i], 0, zeros.length);
            ++i;
        }
    }

    public void initialize() {
        this.imageWidth = this.imageMatrix[0].length;
        this.imageHeight = this.imageMatrix.length;
        double[][] imageMatrixCoeffs = this.blockRearrange(this.imageMatrix);
        this.pcaMatrix = new Matrix(imageMatrixCoeffs);
        Matrix covariance = this.cov(this.pcaMatrix);
        EigenvalueDecomposition evd = covariance.eig();
        this.eigenVectors = evd.getV();
        this.eigenValues = evd.getD();
        this.invEigenVectors = this.eigenVectors.inverse();
    }

    public double[][] applyKLTByNumberOfCoefficients(int cantCoeffs) {
        Matrix kltImage = this.pcaMatrix.times(this.eigenVectors);
        double[][] kltImageMatrix = kltImage.getArrayCopy();
        this.pruneCoeffs(kltImageMatrix, cantCoeffs);
        return kltImageMatrix;
    }

    public double[][] getInvBasis() {
        return this.invEigenVectors.getArrayCopy();
    }

    public static double[][] apply(double[][] invBasis, int imageWidth, int imageHeight, int BLOCK_WIDTH, double[][] coeffs) {
        Matrix invEigenVectors = new Matrix(invBasis);
        Matrix kltImageMatrix = new Matrix(coeffs);
        Matrix kltDecodedImage = kltImageMatrix.times(invEigenVectors);
        return KLTHelper.unblockRearrange(kltDecodedImage.getArrayCopy(), imageWidth, imageHeight, BLOCK_WIDTH);
    }

    public Matrix cov(Matrix inputMatrix) {
        int m = inputMatrix.getRowDimension();
        int n = inputMatrix.getColumnDimension();
        Matrix X = new Matrix(n, n);
        int degrees = m - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                int k = 0;
                while (k < m) {
                    s1 += inputMatrix.get(k, i);
                    s2 += inputMatrix.get(k, j);
                    ++k;
                }
                s1 /= (double)m;
                s2 /= (double)m;
                int k2 = 0;
                while (k2 < m) {
                    c += (inputMatrix.get(k2, i) - s1) * (inputMatrix.get(k2, j) - s2);
                    ++k2;
                }
                X.set(i, j, c / (double)degrees);
                ++j;
            }
            ++i;
        }
        return X;
    }

    private static double[][][] convertColorSpace(Matrix cvtMatrix, double[][][] imageMatrix) {
        int imageWidth = imageMatrix[0][0].length;
        int imageHeight = imageMatrix[0].length;
        double[][] inputMatrix = new double[3][imageWidth * imageHeight];
        int k = 0;
        int j = 0;
        while (j < imageHeight) {
            int i = 0;
            while (i < imageWidth) {
                inputMatrix[0][k] = imageMatrix[0][j][i];
                inputMatrix[1][k] = imageMatrix[1][j][i];
                inputMatrix[2][k++] = imageMatrix[2][j][i];
                ++i;
            }
            ++j;
        }
        double[][] result = cvtMatrix.times(new Matrix(inputMatrix)).getArray();
        double[][][] resultMatrix = new double[3][imageHeight][imageWidth];
        k = 0;
        int j2 = 0;
        while (j2 < imageHeight) {
            int i = 0;
            while (i < imageWidth) {
                resultMatrix[0][j2][i] = result[0][k];
                resultMatrix[1][j2][i] = result[1][k];
                resultMatrix[2][j2][i] = result[2][k++];
                ++i;
            }
            ++j2;
        }
        return resultMatrix;
    }

    public static double[][][] convertToYCrCb(double[][][] imageMatrix) {
        return KLTHelper.convertColorSpace(new Matrix(RGBToYCrCbMatrix), imageMatrix);
    }

    public static double[][][] convertToRGB(double[][][] imageMatrix) {
        return KLTHelper.convertColorSpace(new Matrix(YCrCbToRGBMatrix), imageMatrix);
    }
}

