/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.image;

import com.brownsoft.image.ImageCanvas;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class PGMEncoder {
    int[] imageVector;
    double[][] imageMatrix;
    int width;
    int height;
    protected String ImageType;
    protected String HeaderId;
    protected int BandCount;
    protected int ColorType;

    public PGMEncoder(double[][] imageMatrix) {
        this(imageMatrix, "PGM", "P5", 1, 10);
    }

    public PGMEncoder(double[][] imageMatrix, String ImageType, String HeaderId, int BandCount, int ColorType) {
        this.ImageType = ImageType;
        this.HeaderId = HeaderId;
        this.BandCount = BandCount;
        this.ColorType = ColorType;
        this.imageMatrix = imageMatrix;
        this.width = imageMatrix[0].length;
        this.height = imageMatrix.length;
        this.setImageVector();
    }

    private void setImageVector() {
        this.imageVector = new int[this.width * this.height];
        int k = 0;
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width) {
                this.imageVector[k++] = (int)this.imageMatrix[j][i];
                if (this.imageVector[k - 1] < 0) {
                    this.imageVector[k - 1] = -this.imageVector[k - 1];
                }
                if (this.imageVector[k - 1] > 255) {
                    this.imageVector[k - 1] = 255;
                }
                ++i;
            }
            ++j;
        }
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, this.ColorType);
        WritableRaster raster = image.getRaster();
        raster.setPixels(0, 0, this.width, this.height, this.imageVector);
        return image;
    }

    public void showImage(String title) {
        try {
            Frame frame = new Frame(title + " - PGMEncoder (u)2004, Gustavo Brown");
            frame.add(new ImageCanvas(this.getImage()));
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    evt.getWindow().dispose();
                }
            });
            frame.pack();
            frame.show();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

