/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.klt;

import com.brownsoft.codec.KLTDecoder;
import com.brownsoft.image.ImageCanvas;
import java.io.File;

public class DecodeKLT {
    public static void main(String[] args) {
        System.err.println("DecodeKLT v1.0, (u)2004, Gustavo Brown Rodriguez");
        System.err.println();
        String file = null;
        if (args.length > 0) {
            if (new File(args[args.length - 1]).isFile()) {
                file = args[args.length - 1];
            } else if (new File(args[args.length - 1] + ".klti").isFile()) {
                file = args[args.length - 1] + ".klti";
            }
        }
        if (file == null) {
            System.err.println("USO: com.brownsoft.klt.EncodeKLT [Argumentos] Nombre de archivo .klti");
            System.err.println();
            System.err.println("Argumentos:");
            System.err.println("\t-kNombre Codificar usando la base de la klt a partir del archivo .kltc");
            System.err.println("\t-n Mostrar decodificaci\u00f3n de cada canal");
            return;
        }
        boolean useExternalKLTBase = false;
        boolean showBands = false;
        String externalKLTBase = null;
        int i = 0;
        while (i < args.length - 1) {
            String arg = args[i].trim();
            if (arg.length() != 0) {
                if (arg.charAt(0) != '-') {
                    System.err.println("Ignorando parametro: '" + arg + "'");
                } else if (arg.length() != 1) {
                    String parm = arg.substring(2);
                    switch (arg.charAt(1)) {
                        case 'n': {
                            showBands = true;
                            break;
                        }
                        case 'k': {
                            useExternalKLTBase = true;
                            externalKLTBase = parm;
                            if (externalKLTBase.indexOf(46) != -1) break;
                            externalKLTBase = externalKLTBase + ".kltc";
                            break;
                        }
                        default: {
                            System.err.println("Argumento no reconocido: " + arg);
                        }
                    }
                }
            }
            ++i;
        }
        try {
            KLTDecoder decoder = new KLTDecoder(file);
            System.err.println("Tama\u00f1o de la imagen: " + decoder.getImageSize().x + "x" + decoder.getImageSize().y);
            System.err.println("Tipo de la imagen: " + DecodeKLT.getImageType(decoder.getImageType()));
            System.err.println("Tama\u00f1o del bloque: " + decoder.getBlockSize());
            System.err.println("Comentario: " + decoder.getComment());
            System.err.println("BitsPerPixel: " + (double)new File(file).length() * 8.0 / (double)(decoder.getImageSize().x * decoder.getImageSize().y));
            if (decoder.getKLTVectorsEmbeded()) {
                System.err.println("Coeficientes de la base: embebidos");
            } else if (!useExternalKLTBase) {
                externalKLTBase = file;
                if (externalKLTBase.endsWith(".klti")) {
                    externalKLTBase = externalKLTBase.substring(0, externalKLTBase.length() - 5) + ".kltc";
                }
                if (externalKLTBase.indexOf(46) == -1) {
                    externalKLTBase = externalKLTBase + ".kltc";
                }
                if (!new File(externalKLTBase).isFile()) {
                    System.err.println("Debe indicar un archivo de coeficientes (.kltc) mediante el argumento -k");
                    return;
                }
                useExternalKLTBase = true;
            }
            if (useExternalKLTBase) {
                System.err.println("Utilizando coeficientes del archivo: '" + externalKLTBase + "'");
                decoder.setKLTBaseName(externalKLTBase);
            }
            decoder.setShowBands(showBands);
            System.err.println();
            ImageCanvas.showImage(file, decoder.decode());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String getImageType(int type) {
        switch (type) {
            case 0: {
                return "Escala de grises";
            }
            case 2: {
                return "Color RGB";
            }
            case 3: {
                return "Color YCrCb";
            }
        }
        return "Desconocido";
    }
}

