/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.klt;

import Jama.EigenvalueDecomposition;
import com.brownsoft.codec.KLTEncoder;
import com.brownsoft.image.ImageCanvas;
import com.brownsoft.image.PGMDecoder;
import com.brownsoft.image.PPMDecoder;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;

public class EncodeKLT {
    String[] args;

    public static void main(String[] args) {
        System.err.println("EncodeKLT v1.0, (u)2004, Gustavo Brown Rodriguez");
        System.err.println();
        String file = null;
        if (args.length > 0 && new File(args[args.length - 1]).isFile()) {
            file = args[args.length - 1];
        }
        if (file == null) {
            System.err.println("USO: com.brownsoft.klt.EncodeKLT [Argumentos] Archivo .pgm/.ppm/.jpg/.gif");
            System.err.println();
            System.err.println("Argumentos:");
            System.err.println("\t-bN Tama\u00f1o de bloque NxN (4-64), por defecto=8");
            System.err.println("\t-cN Cantidad de coeficientes a considerar, por defecto=2*tama\u00f1o bloque");
            System.err.println("\t-qN Calidad (1-100)");
            System.err.println("\t-j[Nombre] Guardar base de la klt [en el archivo indicado]");
            System.err.println("\t-kNombre Codificar usando la base de la klt a partir del archivo .kltc");
            System.err.println("\t-y Codificar imagen color en espacio YCrCb (valor por defecto)");
            System.err.println("\t-r Codificar imagen color en espacio RGB");
            System.err.println("\t-g Codificar imagen color en escala de grises");
            System.err.println("\t-oNombre Nombre del archivo de salida");
            System.err.println("\t-m\"Msg\" Comentario asociado a la imagen");
            System.err.println("\t-n Mostrar codificaci\u00f3n de cada canal");
            System.err.println("\t-s Mostrar imagen de entrada");
            System.err.println("\t-p Mostrar progreso de la codificacion");
            return;
        }
        try {
            EncodeKLT encoder = new EncodeKLT(args);
            encoder.process();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public EncodeKLT(String[] args) {
        this.args = args;
    }

    private String getOutFile(String file) {
        String inFile = File.separator + new File(file).getAbsolutePath();
        int index = inFile.lastIndexOf(File.separator);
        int index2 = inFile.lastIndexOf(46);
        if (index2 == -1 || index2 < index) {
            return file + ".klti";
        }
        return file.substring(0, file.lastIndexOf(46)) + ".klti";
    }

    public void process() throws IOException {
        String file = this.args[this.args.length - 1];
        Image image = file.toLowerCase().endsWith(".ppm") ? new PPMDecoder(file).getImage() : (file.toLowerCase().endsWith(".pgm") ? new PGMDecoder(file).getImage() : Toolkit.getDefaultToolkit().getImage(file));
        KLTEncoder encoder = new KLTEncoder(image);
        int cantCoeffs = -1;
        int blockSize = 8;
        int quality = -1;
        String outFile = this.getOutFile(file);
        String comment = "";
        boolean showBands = false;
        boolean showInputImage = false;
        boolean showProgress = false;
        byte outputImageType = 3;
        boolean useExternalKLTBase = false;
        boolean createExternalKLTBase = false;
        String externalKLTBase = null;
        String externalLoadKLTBase = null;
        int i = 0;
        while (i < this.args.length - 1) {
            String arg = this.args[i].trim();
            if (arg.length() != 0) {
                if (arg.charAt(0) != '-') {
                    System.err.println("Ignorando parametro: '" + arg + "'");
                } else if (arg.length() != 1) {
                    String parm = arg.substring(2);
                    switch (arg.charAt(1)) {
                        case 'b': {
                            blockSize = Integer.parseInt(parm);
                            if (blockSize >= 4 && blockSize <= 64) break;
                            System.err.println("El tama\u00f1o del bloque debe ser entre 4 y 64");
                            break;
                        }
                        case 'c': {
                            cantCoeffs = Integer.parseInt(parm);
                            if (cantCoeffs >= 1 && cantCoeffs <= blockSize * blockSize) break;
                            System.err.println("La cantidad de coeficientes debe ser menor que el blockSize^2");
                            break;
                        }
                        case 'q': {
                            quality = Integer.parseInt(parm);
                            if (quality >= 1 && quality <= 100) break;
                            System.err.println("La calidad debe valer entre 1 y 100");
                            break;
                        }
                        case 'o': {
                            outFile = parm;
                            if (outFile.indexOf(46) != -1) break;
                            outFile = outFile + ".klti";
                            break;
                        }
                        case 'm': {
                            comment = parm;
                            break;
                        }
                        case 'n': {
                            showBands = true;
                            break;
                        }
                        case 's': {
                            showInputImage = true;
                            break;
                        }
                        case 'p': {
                            showProgress = true;
                            EigenvalueDecomposition.DEBUG = true;
                            break;
                        }
                        case 'y': {
                            outputImageType = 3;
                            break;
                        }
                        case 'r': {
                            outputImageType = 2;
                            break;
                        }
                        case 'g': {
                            outputImageType = 0;
                            break;
                        }
                        case 'j': {
                            if (parm.startsWith("[") && arg.endsWith("]")) {
                                System.err.println("Los [ ] indican parametro opcional");
                                parm = parm.substring(1, parm.length() - 2);
                            }
                            createExternalKLTBase = true;
                            if (parm.equals("")) break;
                            externalKLTBase = parm;
                            break;
                        }
                        case 'k': {
                            useExternalKLTBase = true;
                            externalLoadKLTBase = parm;
                            break;
                        }
                        default: {
                            System.err.println("Argumento no reconocido: " + arg);
                        }
                    }
                }
            }
            ++i;
        }
        if (createExternalKLTBase) {
            if (externalKLTBase == null && (externalKLTBase = outFile).endsWith(".klti")) {
                externalKLTBase = externalKLTBase.substring(0, externalKLTBase.length() - 5) + ".kltc";
            }
            if (externalKLTBase.indexOf(46) == -1) {
                externalKLTBase = externalKLTBase + ".kltc";
            }
            encoder.setKLTBaseOutputName(externalKLTBase);
            encoder.setEmbedKLTVectors(false);
        }
        if (useExternalKLTBase) {
            if (externalLoadKLTBase.indexOf(46) == -1) {
                externalLoadKLTBase = externalLoadKLTBase + ".kltc";
            }
            encoder.setKLTBaseName(externalLoadKLTBase);
        }
        encoder.setComment(comment);
        encoder.setBlockSize(blockSize);
        if (cantCoeffs != -1) {
            encoder.setNumberOfCoefficients(cantCoeffs);
        } else {
            encoder.setNumberOfCoefficients(2 * blockSize);
        }
        if (quality != -1) {
            encoder.setQuality(quality);
        }
        if (showInputImage) {
            ImageCanvas.showImage(file, image);
        }
        encoder.setShowBands(showBands);
        encoder.setShowProgress(showProgress);
        encoder.setOutputImageType(outputImageType);
        encoder.encodeImage(outFile);
    }
}

