function showTasks(proyectName) {

    $(".proyect_" + proyectName  + "_task").each(function(){
        $(this).toggle();
    });
}


$(function () {
    $('.hours').focusin(function () {
        var task_id = $(this).parents('tr').attr('data-id');

        //Y cada vez que abro un add, tengo que cerrar los otros.
        $('.add').not('.hide').each(function( index ) {
            var task_id = $(this).parents('tr').attr('data-id');
            $('#start_'+task_id).removeClass('hide');
            $('#add_'+task_id).addClass('hide');
            $('#hours').val('00:00');
        });

        //Mostramos el boton add solo cuando la tarea esta sin empezar
        if ( $('#stop_'+task_id).hasClass('hide')) {
            $(this).val('');
            $('#start_'+task_id).addClass('hide');
            $('#add_'+task_id).removeClass('hide');
        }

    })

    $('.hours').focusout(function () {
        if (this.value === ''){
            this.value = '0:00';
        }
    })


    $('.add').click(function () {
        //var task_id = $(this).parents('tr').attr('data-id');
        //var horas = $('#hours_'+task_id).val();
        //$('#hours_'+task_id).prop('readonly','readonly');
        //$(this).addClass('hide');
        //$('#start_'+task_id).removeClass('hide');
        //window.location.href = 'entries/'+task_id+'/'+horas+'/initEntry';
    })

    $('.start').click(function () {
        var task_id = $(this).parents('tr').attr('data-id');
        $(this).addClass('hide');
        $('#stop_'+task_id).removeClass('hide');
        startTimer('timer_'+task_id);
    })

    $('.stop').click(function () {
        var task_id = $(this).parents('tr').attr('data-id');
        $(this).addClass('hide');
        $('#start_'+task_id).removeClass('hide');
        $('#add_'+task_id).click(); //envio el formulario para la pagina de ingresar horas

    })

    // Arranca los timers si es distinto a 00:00
    $('.hours').each(function( index ) {
        if ( $(this).val() != '00:00') {
            var task_id = $(this).parents('tr').attr('data-id');

            startTimer( 'timer_'+task_id);
            $(this).parent().next().find('.start').addClass('hide');   //muestro el boton de stop
            $(this).parent().next().find('.stop').removeClass('hide'); // y oculto el start
        }

    });
});

   // FUNCIONES PARA EL TIMER

function toHHMMSS( s)  {
    var sec_num = parseInt(s, 10); // don't forget the second parm
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}
    var time    = hours+':'+minutes+':'+seconds;
    return time;
}


function timer(elementId){
    var current_time = $('.'+elementId).val();

    var total_seconds = 0;
    if (current_time != '00:00') {
        var hours = parseInt(current_time.split(':')[0]);
        var minutes = parseInt(current_time.split(':')[1]);
        total_seconds = hours*60*60 + minutes*60;

        if (current_time.split(':').length == 3)  {           //existen los segundos
            var seconds = parseInt(current_time.split(':')[2]);
            total_seconds = hours*60*60 + minutes*60 +seconds;
        }

    }
    this.startTime = new Date(Date.now() - total_seconds*1000);
    this.update(elementId);
    var that = this;
}


timer.prototype.stop=function(){
    clearTimeout(this.timerKey);
}

timer.prototype.update=function(elementId){
    var seconds = toHHMMSS (parseInt((Date.now() - this.startTime ) / 1000) );

    $('.'+elementId).val(seconds);
    var self = this;
    this.timerKey = setTimeout(function(){self.update(elementId);},1000);
}
var timers = [];

function startTimer(timerName) {
    var timerObj = new timer(timerName);
    timers[timerName] = timerObj;
}

function stopTimer(timerName) {
    var timerObj = timers[timerName];
    if(timerObj) timerObj.stop();
}