class ApplicationController < ActionController::Base
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  protect_from_forgery with: :exception

  helper_method :mobil_user
  helper_method :current_user
  helper_method :user_signed_in?
  #helper_method :correct_user?

  private


  def current_user
    begin
      @current_user ||= User.find(session[:user_id]) if session[:user_id]
    rescue Exception => e
      nil
    end
  end

  def user_signed_in?
    return true if current_user
  end

  # Comentadas por que por ahora no se usan pero seguramente en otro sprint se necesiten
  #
  #def correct_user?
  #  @user = User.find(params[:id])
  #  unless current_user == @user
  #    redirect_to root_url, :alert => "Access denied."
  #  end
  #end
  #
  #def authenticate_user!
  #  if !current_user
  #    redirect_to root_url, :alert => 'You need to sign in for access to this page.'
  #  end
  #end


  def mobil_user
    begin
      @mobil_user = User.where(email: 'mobil@user.com', enabled: true).first_or_create
        #@current_user ||= User.find(session[:user_id]) if session[:user_id]
        #@mobil_user.commitment_hours = "6:00"

    rescue Exception => e
      nil
    end
  end

  rescue_from CanCan::AccessDenied do |exception|
    redirect_to root_path, :alert => exception.message
  end

end
