class CronReportsController < ApplicationController
  before_action :set_cron_report, only: [:show, :edit, :update, :destroy]
  layout "backend/application"

  # GET /cron_reports
  # GET /cron_reports.json
  def index
    @cron_reports = CronReport.all
  end

  # GET /cron_reports/1
  # GET /cron_reports/1.json
  def show

  end

  # GET /cron_reports/new
  def new
    @cron_report = CronReport.new
  end

  # GET /cron_reports/1/edit
  def edit
  end

  # POST /cron_reports
  # POST /cron_reports.json
  def create
    @cron_report = CronReport.new(cron_report_params)

    respond_to do |format|
      if @cron_report.save
        format.html { redirect_to @cron_report, notice: 'Cron report was successfully created.' }
        format.json { render action: 'show', status: :created, location: @cron_report }
      else
        format.html { render action: 'new' }
        format.json { render json: @cron_report.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /cron_reports/1
  # PATCH/PUT /cron_reports/1.json
  def update
    respond_to do |format|
      if @cron_report.update(cron_report_params)
        format.html { redirect_to @cron_report, notice: 'Cron report was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @cron_report.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /cron_reports/1
  # DELETE /cron_reports/1.json
  def destroy
    @cron_report.destroy
    respond_to do |format|
      format.html { redirect_to cron_reports_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_cron_report
      @cron_report = CronReport.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def cron_report_params
      params.require(:cron_report).permit(:id, :periodicity_days, :filter, :type, :start_date, :emails, :project_id)
    end
end
