
require 'ToolAdapter'


class EntriesController < ApplicationController
  before_action :set_entry, only: [:show, :edit, :update, :destroy]

  # GET /entries
  # GET /entries.json
  def index
    @entries = Entry.all
  end

  # GET /entries/1
  # GET /entries/1.json
  def show
  end

  # GET /entries/new
  def new
    @entry = Entry.new
  end

  def initEntry
    @entry = Entry.new()
    @entry.task_id = params[:id]
    @entry.user_id = params[:user_id]
    @entry.hours = params[:send_info][:hours]
    if !(@entry.valid?)
      redirect_to tasks_path, alert: 'Incorrect format.'
    end
    @category = Category.all
  end

  def confirmEntry
    task_id = params[:task_id]
    @task = Task.find(task_id)
    @entry = Entry.new()
    @entry.task_id = params[:task_id]
    @entry.user_id = params[:user_id]
    @entry.hours = params[:hours]
    @entry.date = Time.now()
    @entry.category_id = params[:entry][:cat_id]
    @entry.comment = params[:entry][:comment]
    if !(@entry.valid?)
      redirect_to tasks_path, alert: 'Incorrect format.'
    else
      @entry.save()
      @entry.save_sync(@task)

      #borramos la entry con status pendiente que solo se usaba para mantener el estado del timer
      pending_entry = @task.entries.where('status = ?','pending').first
      if (pending_entry)
        pending_entry.destroy!
      end

      redirect_to tasks_path, notice: 'Successful entry'
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_entry
      @entry = Entry.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def entry_params
      params.require(:entry).permit(:hours, :date, :category_id, :comment, :task_id)
    end
end
