class ProjectsController < ApplicationController
  before_action :set_project, only: [:show, :edit, :update, :destroy]
  load_and_authorize_resource
  layout "backend/application"

  # GET /projects
  # GET /projects.json
  def index
    @projects = Project.all

    respond_to do |format|
      format.html { render html: @categories }
      format.json { render json: @projects }
      format.xml { render xml: @projects }
    end
  end

  # GET /projects/1
  # GET /projects/1.json
  def show
    @hours_per_category = Project.generate_cronReport(params[:id])
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_project
      @project = Project.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def project_params
      params.require(:project).permit(:name, :url, :user_id)
    end
end
