class SessionsController < ApplicationController

  #before_action :current_user

  #patch para que ande el openid
  skip_before_filter :verify_authenticity_token or protect_from_forgery :except => :create

  def new
    redirect_to '/auth/google_oauth2'
  end

  def new_openid
    redirect_to '/auth/google'
  end

  def create


    auth = request.env["omniauth.auth"]

    if  User.where(:provider => auth['provider'],:uid => auth['uid'].to_s).count == 0 && User.admin.count == 1
      redirect_to root_url, :alert => "Authentication error"
      return
    end
    user = User.where(:provider => auth['provider'],:uid => auth['uid'].to_s).first || User.create_with_omniauth(auth)

    # Reset the session after successful login, per
    # 2.8 Session Fixation – Countermeasures:
    # http://guides.rubyonrails.org/security.html#session-fixation-countermeasures
    reset_session
    session[:user_id] = user.id

    if User.admin.count == 0   # No hay admins asi que lo creo al primero que entra al backend
      user.add_role :admin
    end

    if user.email.blank?
      redirect_to root_url, :alert => "Please enter your email address."
    else
      redirect_to menu_url
    end

  end

  def destroy
    reset_session
    redirect_to root_url
  end

  def failure
    redirect_to root_url, :alert => "Authentication error: #{params[:message].humanize}"
  end

end
