require 'ProjectTaskParser'

class TasksController < ApplicationController

  before_action :set_task, only: [:show,:edit, :update, :start]


  #Esto es un helper se ejecuta primero, emula al usuario que esta logueado generando una variable @current_user
  before_action :mobil_user

  def start
    @entry = Entry.new(:task_id => @task.id)
    @entry.status = 'pending'
    @entry.hours = '00:00'
    respond_to do |format|
      if @entry.save
        format.js
      else
        format.js
      end
    end
  end

  def stop

  end


  def sync_tasks
    respond_to do |format|

      if Task.sync_user_tasks(@mobil_user)
        format.html { redirect_to tasks_url, notice: 'Sync Successfully.' }
      else
        format.html { redirect_to tasks_url, alert: 'Sync Error.' }
      end
    end
  end

  # GET /tasks
  # GET /tasks.json
  # Crea un hash de array cada. la KEY es el nombre del project, el VALUE es un array de tasks.
  #  last modified tasks son aquellas 3 ultimas a las cuales se les metieron entries.
  #TODO: alguno de estos metodos podrian moverse al model
  def index
    @task_groups = Hash.new{|h, k| h[k] = []}

    temporal_last_tasks = @mobil_user.tasks.joins(:entries).order('entries.updated_at desc')
    last_tasks = []
    temporal_last_tasks.each do |last_task|
      last_tasks.push last_task unless last_tasks.include? last_task
      break if last_tasks.size==3
    end


    #muestro la desviacion para el usuario
    #@user_commitment = @mobil_user.commitmentDeviation
    @user_commitment = @mobil_user.commitmentDeviation

    @tasks = @mobil_user.tasks.order('updated_at desc')


    @task_groups['Last Modified'] = last_tasks;
    @tasks.each do |task|
      @task_groups[task.project.name] << task unless last_tasks.include? task or task.project.nil?
    end

  end


  def search
    @searched_groups = Hash.new{|h, k| h[k] = []}

    @searching_area, @task_criteria, @project_criteria = parser_search_proy_task(params[:query])
    @task_criteria = @task_criteria.strip unless @task_criteria.nil?
    @project_criteria = @project_criteria.strip unless @project_criteria.nil?

    @search = Task.search(@task_criteria, @project_criteria, @searching_area, @mobil_user.id)

    if @search.nil?
      @msg = 'No results found. You must enter a criteria'

    elsif @search.empty?
      @msg = "No results found for '" << params[:query] << "'"

    elsif @searching_area == 'only_projects'
      @search.each do |task|
        @searched_groups[task.project.name] << task
      end
    end

=begin
    respond_to do |format|
       format.js
    end
=end

  end

  # GET /tasks/1
  # GET /tasks/1.json
  def show
  end

  # GET /tasks/1/edit
  def edit
  end

  # PATCH/PUT /tasks/1
  # PATCH/PUT /tasks/1.json
  def update
    respond_to do |format|
      if @task.update(task_params)

          @estimation = params[:hora].to_s + ":" + params[:min].to_s
          @task.estimation = @estimation
          @task.save
          myTask = Task.find(@task.id)
          myCredentials = ToolAuth.get_credential(myTask.project_id,@mobil_user.id)
          myClient = ToolAdapter.new(@mobil_user.id, myCredentials)
          myClient_msg = myClient.update_task(myTask)
          if myClient_msg.to_s != ''
              pre_sync = ToolSync.new()
              pre_sync.create_SyncTask(@task.id,myCredentials,'Update',myClient_msg.to_s)
              format.html { redirect_to @task, notice: 'Task update left for next synchronization.' }
              format.json { head :no_content }
          else
              format.html { redirect_to @task, notice: 'Task was successfully updated.' }
              format.json { head :no_content }
          end


      else
        format.html { render action: 'edit' }
        format.json { render json: @task.errors, status: :unprocessable_entity }
      end
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_task
      @task = Task.find(params[:id])
      users = User.all()
      user = users.find(@task.user_id)
      @user_name = user.name
      entries = Entry.all()
      hours_worked = 0
      minutes_worked = 0
      entries.each do |entry|
        if (entry.task_id == @task.id)
          time = entry.hours.split(':')
          hours = time[0].to_i
          minutes = time[1].to_i
          if ((minutes_worked + minutes) >= 60)
            hours_worked = hours_worked + 1
            minutes_worked = minutes_worked + minutes - 60
          else
            minutes_worked = minutes_worked + minutes
          end
          hours_worked = hours_worked + hours
        end
      end
      string_minutes = minutes_worked.to_s
      if (minutes_worked < 10)
        string_minutes = '0' + string_minutes
      end
      string_hours = hours_worked.to_s
      if (hours_worked < 10)
        string_hours = '0' + string_hours
      end
      @total_hours_worked = string_hours + ':' + string_minutes
    end
    # Never trust parameters from the scary internet, only allow the white list through.
    def task_params
      params.require(:task).permit(:name, :status, :externalId, :estimation, :priority, :due_date, :description, :project_id, :user_id)
    end

end
