require 'rake'
load File.join(Rails.root, 'lib', 'tasks', 'set_frequency_sync_tasks.rake')

class TimerJobsController < ApplicationController

  def initialize()

  end

  def clean_frequency_sync_task()
    # Si la linea ya existe en el archivo debemos eliminarla.
    # La opcion /o al final permite la interpolacion de variables usando #{}.
    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)
    File.open(file_name, "w") {|file| file.puts text.gsub(/^every(\s+)1\.day,(\s+):at =>(\s+)'(\d){1,2}:(\d){1,2}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.new\.run_SyncTask_From_DB\(\)\")(\s+)(runner(\s+)\"ToolSync\.new\.run_SyncEntry_From_DB\(\)\")(\s+)(runner(\s+)\"ToolSync\.new\.run_SyncTask_To_DB\(\)\")(\s+)end(\s+)$/, "")}

    # Actualizamos el crontab para hacer efectivo los cambios.
    Rake::Task['update_sync_frequency'].invoke
  end


  def set_frequency_sync_tasks(sync_frequency)
    # Usamos una tarea rake para ejecutar el comando de actualizacion de cron.
    # Se puede ver lo que hace la tarea en el archivo lib/tasks/set_frequency_sync_tasks.rake
    # La variable user_sync_frequency esta en formato Time y debemos pasarla
    # formato String para poder extraer los valores digitados por el usuario.

    time = sync_frequency.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    # Si la linea ya existe en el archivo debemos eliminarla.
    # La opcion /o al final permite la interpolacion de variables usando #{}.
    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)
    File.open(file_name, "w") {|file| file.puts text.gsub(/^every(\s+)1\.day,(\s+):at =>(\s+)'(\d){1,2}:(\d){1,2}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.new\.run_SyncTask_From_DB\(\)\")(\s+)end(\s+)$/, "")}

    # Una vez eliminada la linea empezamos a construir la linea nueva.
    exec_time = "every 1.day, :at => \'#{hours}:#{minutes}\' do"

    # Agregamos los datos al archivo de scheduling.
    File.open("#{file_path}#{scheduler_file}", "a+") do |file|
      file << "#{exec_time}\n"
      file << "\trunner \"ToolSync.new.run_SyncTask_From_DB()\"\n"
      file << "\trunner \"ToolSync.new.run_SyncEntry_From_DB()\"\n"
      file << "\trunner \"ToolSync.new.run_SyncTask_To_DB()\"\n"
      file << "end\n\n"
    end

    # Actualizamos el crontab para hacer efectivo los cambios.
    Rake::Task['update_sync_frequency'].invoke
  end

end
