require 'ToolAdapter'

class ToolAuthsController < ApplicationController
  before_action :set_tool_auth, only: [:show, :edit, :update, :destroy]

  #helper que emula al usuario que esta logueado generando una variable @current_user
  before_action :mobil_user

  # GET /tool_auths
  # GET /tool_auths.json
  def index
    @tool_auths = ToolAuth.where(user_id:mobil_user.id)
  end

  # GET /tool_auths/1
  # GET /tool_auths/1.json
  def show
  end

  # GET /tool_auths/new
  def new
    @tool_auth = ToolAuth.new
  end

  # GET /tool_auths/1/edit
  def edit
  end

  # POST /tool_auths
  # POST /tool_auths.json
  def create
    @tool_auth = ToolAuth.new(tool_auth_params)
    @tool_auth.user_id = @mobil_user.id
    @url = params[:tool_auth][:url]
    @url = @url.downcase

    tool_options = {
        url: params[:tool_auth][:url],
        tool_user: params[:tool_auth][:tool_user],
        password: params[:tool_auth][:password],
        api_key: params[:tool_auth][:api_key],
        tool_name: params[:tool_auth][:tool_name]
    }

    myClient = ToolAdapter.new(@mobil_user.id)
    response = myClient.check_credentials(tool_options)

    respond_to do |format|
      if (response.nil? || response.empty?)

        if ToolAuth.exist_credentials(@mobil_user,@url)
          format.html { redirect_to :back, alert: 'This credential already belongs to the user.' }
          format.json { render json: @tool_auth.errors, status: :unprocessable_entity }
        else
          if @tool_auth.save
            label_tool_name = params[:tool_auth][:tool_name]
            message = "Tool auth was successfully created. #{label_tool_name.capitalize} Powered."
            format.html { redirect_to :tool_auths, notice: message }
            format.json { render action: 'show', status: :created, location: @tool_auth }
          end
        end

      else
        #response_toombs = 'One or more errors ocurred during validation; check your credentials.'
        #format.html { redirect_to :back, alert: response_toombs }
        format.html { redirect_to :back, alert: response }
        format.json { render json: @tool_auth.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /tool_auths/1
  # PATCH/PUT /tool_auths/1.json
  def update
    respond_to do |format|
      if @tool_auth.update(tool_auth_params)
        format.html { redirect_to @tool_auth, notice: 'Tool auth was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @tool_auth.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /tool_auths/1
  # DELETE /tool_auths/1.json
  def destroy
    @tool_auth.destroy
    respond_to do |format|
      format.html { redirect_to tool_auths_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_tool_auth
      @tool_auth = ToolAuth.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def tool_auth_params
      params.require(:tool_auth).permit(:url, :tool_user, :password, :api_key, :tool_name)

    end
end
