class Entry < ActiveRecord::Base
  belongs_to :task
  has_one :category
  has_one :user

  #has_one :project, through :task
  validates_format_of :hours, :with => /\A(\d\d?:)?\d\d?:\d\d$\Z/
  before_save :format_hours


  require 'ToolAdapter'
  require 'tool_sync'

  def save_sync(task)

    tool_auth = get_credential(task.project_id, task.user_id)
    return false  if tool_auth.nil?
    myClient = ToolAdapter.new(task.user_id, tool_auth)

    myClient_msg = myClient.create_entry(task.externalId, self.comment,self.date,self.hours)

    # Si falla el impacto contra la herramienta de gestión, se guarda para sincronizar en otro momento
    if myClient_msg.to_s != 'Successful entry.'
      pre_sync = ToolSync.new()
      pre_sync.create_SyncEntry(self.id,tool_auth.id,'Insert',myClient_msg.to_s)
    end
  end


  # Parametros: project_id: ID del proyecto
  #             user_if: ID del usuario
  # Retorna las credenciales para el proyecto y usario pasado por parametro. sino retorna nil
  def get_credential(project_id, user_id)
    user = User.find(user_id)
    project = Project.find(project_id)

    user_credentials = user.tool_auths.to_a
    project_credentials = project.tool_auths.to_a

    if user_credentials.empty? or project_credentials.empty?
      return nil
    end

    tool_auth = user_credentials && project_credentials
    if (tool_auth.size >0)
      return tool_auth[0]
    else
      return nil
    end

  end

  #Cambia el formato de 00:00:00 a 00:00
  def format_hours

    if (  !self.hours.blank? && self.hours.split(':').size == 3)
      hours_array = self.hours.split(':')
      hours_array.pop
      self.hours = hours_array.join(':')
    end
  end


end

