class Project < ActiveRecord::Base
  has_many :tasks , :dependent => :destroy
  #has_many :users
  has_and_belongs_to_many :tool_auths
  has_many :cron_reports , :dependent => :destroy

  #scope :of_my_user,	->(user_id) { where('user_id = ?', "#{user_id}") }
  #scope :with_tasks, -> {joins(:tasks)}

  HALF_HOUR = 30.0
  HALF_HOUR_REDMINE = 50.0
  # syncroniza los projects del user con user_id
  def self.sync_user_projects( user)

    return false if user.tool_auths.empty?

    user.tool_auths.each do |tool_auth|
      myClient = ToolAdapter.new(user.id, tool_auth)
      projects = myClient.get_projects()

      projects.each do |project|
        base_project = Project.where(:externalId => project.externalId, :name => project.name).first

        if (base_project.try(:id))
          Project.update(base_project.id, project.attributes.except('id', 'created_at', 'updated_at'))
        else
          project.save

          project.tool_auths << tool_auth unless project.tool_auths.include? tool_auth #relaciono el toolauth con el project_id si no lo tiene
        end
      end
    end

  end



  def self.generate_cronReport(project_id)
    @tasks = Task.where(project_id: project_id)
    @entries = Entry.all
    entries_tasks = []
    print entries_tasks.methods
    users_with_entry = []
    categories_with_entry = []
    @entries.each do |entry|
      @tasks.each do  |task|
        if entry.task_id == task.id
          entries_tasks << entry
          if not (users_with_entry.include?(entry.user_id))
            users_with_entry << entry.user_id
          end
          if not (categories_with_entry.include?(entry.category_id))
            categories_with_entry << entry.category_id
          end
        end
      end
    end
    #voy a buscar los nombres de los usuarios y de las categorias a la base
    tuple_result =  []
    users_with_entry.each do  |user|
      #obtengo email del usuario para mostrar en reporte
      user_email = User.find(user).email
      categories_with_entry.each do  |category|
        total_hours = 0
        tasks_hours_cat = []
        category_description= Category.find(category).description
        found = false
        entries_tasks.each do  |entry|
          if (user == entry.user_id) and  (category == entry.category_id)
            found = true
            tasks_with_entry = []
            task = Task.find(entry.task_id)
            task_amount_hours = self.getAmountHours(entry.hours)
            existing_task = tasks_hours_cat.select {|t| t["name"] == task.name }
            if (existing_task.length==0)
              tasks_hours_cat << {"name" => task.name, "hours" => task_amount_hours}
            else
              existing_task.first["hours"] += task_amount_hours
            end
            total_hours += task_amount_hours
          end
        end
        if (found)
          tuple_result << {"user_id" => user_email ,"category_id" => category_description, "total_hours" => total_hours, "task_hours" => tasks_hours_cat}
        end
      end
    end
    tuple_result
  end



  private
  # Parameters: time_spent: String of the form 'HH: mm'
  # Returns a string with de Redmine format (number.number)
  def self.getAmountHours(time_spent)

    aux_time = time_spent.split(':')
    minutes_conversion_redmine = (HALF_HOUR_REDMINE / HALF_HOUR).round(6)
    minutes = (aux_time[1].to_i.* minutes_conversion_redmine).round
    hours = aux_time[0].to_i
    resultado = hours.to_s + '.' + minutes.to_s
    return resultado.to_f
  end
end
