#Para merguear(sacar mas tarde)
class Task < ActiveRecord::Base
  has_many :entries   , :dependent => :destroy
  belongs_to :project
  has_one :user

  require 'ToolAdapter'
  require 'tool_sync'


  #TODO el project_id esta para autenticar solamente. Consideramos eliminarlo
  def self.sync_user_tasks( user)
    return ToolSync.new().run_SyncTask_To_DB_Per_User(user)
  end


# Virtual attribute
  attr_accessor :hours
# Getter
  def hours
    pending_entry = self.entries.where('status = ?','pending').first
    if pending_entry
      total_seconds = Time.now - pending_entry.created_at
      seconds = total_seconds % 60
      minutes = (total_seconds / 60) % 60
      hours = total_seconds / (60 * 60)

      @hours = format("%02d:%02d:%02d", hours, minutes, seconds)
    else
      @hours = '00:00'
    end
    @hours
  end

  def self.search(task_criteria, project_criteria, searching_area , user_id)
    if (task_criteria.present? || project_criteria.present? || searching_area == 'not_critery')

      case searching_area
        when 'only_tasks'
          #Task.from(Project.joins("INNER JOIN tasks ON tasks.project_id = projects.id").where("user_id= ?",user_id)).joins("INNER JOIN tasks ON subquery.id = tasks.project_id ").where("lower(tasks.name) LIKE lower(?)","%#{task_criteria}%").group("tasks.name","tasks.id").to_a
          query = Task.from(Project.joins("INNER JOIN tasks ON tasks.project_id = projects.id").\
		  		                        where("user_id= ?",user_id)).\
		                joins("INNER JOIN tasks ON subquery.id = tasks.project_id ").\
                          where("lower(tasks.name) LIKE lower(?)","%#{task_criteria}%").\
		      group("tasks.name","tasks.id")
          self.order_tasks_from_search(query,user_id)


        when 'only_projects'
          query = Task.from(Project.joins("INNER JOIN tasks ON tasks.project_id = projects.id").\
		                              where("user_id= ? AND lower(projects.name) LIKE lower(?)",user_id,"%#{project_criteria}%")).\
                    joins("INNER JOIN tasks ON subquery.id = tasks.project_id ").\
          group("tasks.name","tasks.id")
          self.order_projects_from_search(query,user_id)

        when 'tasks_of_projects'
          query = Task.from(Project.joins("INNER JOIN tasks ON tasks.project_id = projects.id").\
		                              where("user_id= ? AND lower(projects.name) LIKE lower(?)",user_id,"%#{project_criteria}%")).\
		                joins("INNER JOIN tasks ON subquery.id = tasks.project_id ").\
		                      where("lower(tasks.name) LIKE lower(?)","%#{task_criteria}%").\
		      group("tasks.name","tasks.id")
          self.order_tasks_from_search(query,user_id)

        when 'tasks_or_projects'
          only_tasks_results = []


          only_tasks_results = Task.from(Project.joins("INNER JOIN tasks ON tasks.project_id = projects.id").\
		  		                                              where("user_id= ?",user_id)).\
		                                     joins("INNER JOIN tasks ON subquery.id = tasks.project_id ").\
                                               where("lower(tasks.name) LIKE lower(?) OR lower(subquery.name) LIKE lower(?)","%#{task_criteria}%","%#{project_criteria}%").\
		                          group("tasks.name","tasks.id")

         self.order_tasks_from_search(only_tasks_results,user_id)
        else
         []
      end

    # not searching
    else
      nil
    end
  end

  private

  def self.order_tasks_by_MRU_crit1(tasks_to_order)
    temporal_last_tasks = Task.select("subquery.*").from(tasks_to_order).joins("INNER JOIN entries ON entries.task_id = subquery.id").\
                          where("entries.user_id = ?",@id_user).\
                          order("entries.updated_at desc")

    last_tasks = []

    if !temporal_last_tasks.empty?
      temporal_last_tasks.each do |last_task|
        last_tasks.push last_task unless last_tasks.include? last_task
      break if last_tasks.size==3
    end
    end
    return last_tasks
  end

  def self.order_tasks_by_assignment_to_me_crit2(tasks_to_order)
    return Task.select("subquery.*").from(tasks_to_order).where("subquery.user_id = ?",@id_user).order("subquery.due_date asc")
  end

  def self.order_tasks_by_entry_hours_but_not_assignment_to_me_crit3(tasks_to_order)
    return Task.select("subquery.*").from(tasks_to_order).where("subquery.user_id <> ?",@id_user).joins("INNER JOIN entries ON entries.task_id = subquery.id").\
           where("entries.user_id = ?",@id_user).order("subquery.due_date asc")
  end

  def self.order_tasks_by_open_state_but_not_assignment_to_me_crit4(tasks_to_order)
    return tasks_to_order.where("tasks.user_id <> ? AND tasks.status <> 'closed'",@id_user).order("subquery.due_date asc")
  end

  def self.order_tasks_by_closed_state_assignment_to_me_crit5(tasks_to_order)
    return tasks_to_order.where("tasks.user_id = ? AND tasks.status <> 'open'",@id_user).order("subquery.due_date asc")
  end

  def self.order_tasks_by_closed_state_crit6(tasks_to_order)
    return tasks_to_order.where("tasks.status <> 'open'")
  end

  def self.order_tasks_remaining_by_updated_at(tasks_to_order)
    return Task.select("subquery.*").from(tasks_to_order).order("subquery.due_date asc")
  end

  def self.parcial_push_temporal_result(result_crit)
    if !result_crit.empty?
    result_crit.each do |last_task|
      @temporal_result_ordered.push last_task unless @temporal_result_ordered.include? last_task
      break if @temporal_result_ordered.size == @final_size
    end
    end
  end

  def self.order_projects_from_search(search_result,user_id)
    @final_size = search_result.length

    @projects_id_ordered = []

    @final_array_proj_ordered = []

    @tasks_from_proj_ordered_by_entry_desc= Task.select("subquery.*").from(search_result).joins("INNER JOIN entries ON entries.task_id = subquery.id").order("entries.updated_at desc").to_a

    @tasks_from_proj_ordered_by_updated_at_desc_name_asc = Task.select("subquery.*").from(search_result).order("subquery.due_date asc, subquery.name asc").to_a

    @tasks_from_proj_ordered_by_entry_desc.each do |task|
      @projects_id_ordered.push task.project_id unless @projects_id_ordered.include? task.project_id
    end

    @tasks_from_proj_ordered_by_updated_at_desc_name_asc.each do |task|
      @projects_id_ordered.push task.project_id unless @projects_id_ordered.include? task.project_id
    end

    @projects_id_ordered.each do |proj_id|
      @tasks_to_push_final_array = Task.select("subquery.*").from(search_result).where("subquery.project_id= ?",proj_id).order("subquery.due_date asc").to_a
      @tasks_to_push_final_array.each do |task|
        @final_array_proj_ordered.push task
      end
    end
    return @final_array_proj_ordered
  end

  def self.order_tasks_from_search(search_result,user_id)
    @final_size = search_result.length

    @id_user = user_id

    @temporal_result_ordered = []

    result_crit1 = self.order_tasks_by_MRU_crit1(search_result)
    self.parcial_push_temporal_result(result_crit1)

    if @temporal_result_ordered.size < @final_size
      result_crit2 = self.order_tasks_by_assignment_to_me_crit2(search_result)
      self.parcial_push_temporal_result(result_crit2)
      if @temporal_result_ordered.size < @final_size
        result_crit3 = self.order_tasks_by_entry_hours_but_not_assignment_to_me_crit3(search_result)
        self.parcial_push_temporal_result(result_crit3)
        if @temporal_result_ordered.size < @final_size
          result_crit_remaining = self.order_tasks_remaining_by_updated_at(search_result)
          self.parcial_push_temporal_result(result_crit_remaining)
        end

#Aun no estan definidos los criterios sobre tareas cerradas y abiertas claramente
=begin
        if @temporal_result_ordered.size < @final_size
          result_crit4 = self.order_tasks_by_open_state_but_not_assignment_to_me_crit4(search_result)
          self.parcial_push_temporal_result(result_crit4)
          if @temporal_result_ordered.size < @final_size
            result_crit5 = self.order_tasks_by_closed_state_assignment_to_me_crit5(search_result)
            self.parcial_push_temporal_result(result_crit5)
            if @temporal_result_ordered.size < @final_size
              result_crit6 = self.order_tasks_by_closed_state_crit6(search_result)
              self.parcial_push_temporal_result(result_crit6)
            end
          end
        end
=end
      end
    end
    return @temporal_result_ordered
  end


end
