require 'ToolAdapter'

class ToolAuth < ActiveRecord::Base
  has_and_belongs_to_many :projects
  belongs_to :user

  before_save { self.url.downcase! unless self.url.blank? }

  validates :url, presence: true

  # Parameters: user, url
  # Returns true if the url is already associated with the user
    def self.exist_credentials(user,url)

    if user.tool_auths.empty?
      return false
    elsif user.tool_auths.where("user_id = ? AND url = ?", user.id, url).count > 0
      return true
    else
      return false
    end
    end

  # Parametros: project_id: ID del proyecto
  #             user_if: ID del usuario
  # Retorna las credenciales para el proyecto y usario pasado por parametro. sino retorna nil
  def self.get_credential(project_id, user_id)
    user = User.find(user_id)
    project = Project.find(project_id)

    user_credentials = user.tool_auths.to_a
    project_credentials = project.tool_auths.to_a

    if user_credentials.empty? or project_credentials.empty?
      return nil
    end

    tool_auth = user_credentials && project_credentials
    if (tool_auth.size >0)
      return tool_auth[0]
    else
      return nil
    end

  end

end
