require 'httparty'
require 'ToolAdapter'
require 'sync_entry'
require 'sync_task'
require 'entry'
require 'task'

class ToolSync
  include HTTParty

  # Create Methods (se registran los datos que están sin sincronizar)
  def create_SyncEntry(entry_id,tool_auth_id,operation,log)
    @sync_entry = SyncEntry.new()
    @sync_entry.entry_id = entry_id
    @sync_entry.tool_auth_id = tool_auth_id
    @sync_entry.sync_retries = 0
    @sync_entry.operation = operation
    @sync_entry.log = log
    @sync_entry.save()
  end

  def create_SyncTask(task_id,tool_auth_id,operation,log)
    @sync_entry = SyncTask.new()
    @sync_entry.task_id = task_id
    @sync_entry.tool_auth_id = tool_auth_id
    @sync_entry.sync_retries = 0
    @sync_entry.operation = operation
    @sync_entry.log = log
    @sync_entry.save()
  end


  # Sync Methods

  # Sincroniza las entries nuevas o modificadas de la BD con las herramientas de gestión
  # El sentido de la sincronización es desde la BD del sistema hacia la herramienta de gestión
  def run_SyncEntry_From_DB()
    @sync_entries = SyncEntry.all.order('tool_auth_id')
    mySync_msg = ''
    @sync_entries.each do |e|
      myEntry = Entry.find(e.entry_id)
      myTaskId = Task.find(myEntry.task_id).externalId
      myToolAuth = ToolAuth.find(e.tool_auth_id)

      myClient = ToolAdapter.new(0, myToolAuth)
      if e.operation == 'Insert'
        mySync_msg = myClient.create_entry(myTaskId, myEntry.comment, myEntry.date, myEntry.hours)
      else
        if e.operation == 'Update'
          #mySync_msg = myClient.update_entry(myTaskId, myEntry.comment, myEntry.date, myEntry.hours)
          mySync_msg = 'Update_Entry function not implemented!'
        else
          mySync_msg = 'Operation not permitted!'
        end
      end

      if mySync_msg == 'Successful entry.'
        e.destroy
      else
        e.sync_retries = e.sync_retries + 1
        e.log = mySync_msg
        e.save()
      end
    end
  end

  # Sincroniza las tasks nuevas o modificadas de la BD con las herramientas de gestión
  # El sentido de la sincronización es desde la BD del sistema hacia la herramienta de gestión
  def run_SyncTask_From_DB()
    @sync_tasks = SyncTask.all.order('tool_auth_id')
    mySync_msg = ''
    @sync_tasks.each do |t|
      myTask = Task.find(t.task_id)
      myToolAuth = ToolAuth.find(t.tool_auth_id)

      myClient = ToolAdapter.new(0, myToolAuth)
      if t.operation == 'Insert' ### VER SI TIENE SENTIDO, el EXTERNAL ID ES AUTOGENERADO ???
        #mySync_msg = myClient.create_task(myTask)
        mySync_msg = 'Insert_Task function not implemented!'
      else
        if t.operation == 'Update'
          mySync_msg = myClient.update_task(myTask)
        else
          mySync_msg = 'Operation not permitted!'
        end
      end

      if mySync_msg.to_s == ''
        t.destroy
      else
        t.sync_retries = t.sync_retries + 1
        t.log = mySync_msg.to_s
        t.save()
      end
    end
  end


  # Sincroniza las tareas y proyectos para todos los usuarios habilitados del sistema
  # El sentido de la sincronización es desde la herramienta de gestión hacia la BD del sistema
    def run_SyncTask_To_DB()
      @users = User.where(:enabled => true)
      @users.each do |u|
        run_SyncTask_To_DB_Per_User(u)
      end
      # VER SI SE PONE ALGUN LOG! o borrar este comentario
    end

  # Sincroniza las tareas y proyectos para el usuario del sistema pasado como parametro
  # El sentido de la sincronización es desde la herramienta de gestión hacia la BD del sistema
    def run_SyncTask_To_DB_Per_User(user)

      return false if user.tool_auths.empty?

      user.tool_auths.each do |tool_auth|
        myClient = ToolAdapter.new(user.id, tool_auth)
        tasks = myClient.get_user_tasks()
        Project.sync_user_projects(user)     #Sincronización de los Projects del usuario, desde la herramienta de gestión a la BD del sistema

        tasks.each do |task|
          base_task = Task.where(:externalId => task.externalId, :name => task.name).first  # Se busca en la BD del sistema

          # Se genera la relación entre Project y Task
          if !task.external_project_id.blank?
            #project = Project.where(:externalId => task.external_project_id, :tool_auths => tool_auth).first
            #task.project_id = project.id  if project
            project = Project.where(:externalId => task.external_project_id)
            myProyect = nil
            project.each do |project|
              project.tool_auths.each do |tool_auth_proy|
                if tool_auth_proy.id == tool_auth.id
                  myProyect = project
                  break;
                end
              end
            end
            task.project_id = myProyect.id  if myProyect
          end

          if (base_task.try(:id))      # Si existe se hace Update
            Task.update(base_task.id, task.attributes.except('id', 'created_at', 'updated_at'))   #actualiza la tarea de nuestra base con los datos traidos, menos el id, created_at, and update_at
          else                         # Sino existe se hace Insert
            task.save
          end
        end
      end

      return true
    rescue
      return false
    end

end