class User < ActiveRecord::Base
  scope :admin, -> { joins(:roles).where(roles: {name:'admin'}) }

  has_many :tasks
  #has_many :projects
  has_many :tool_auths , :dependent => :destroy
  rolify
  validates_presence_of :email

  def self.create_with_omniauth(auth)
    create! do |user|
      user.provider = auth['provider']
      user.uid = auth['uid']
      user.commitment_hours = auth['commitment_hours']
      user.enabled = true
      if auth['info']
        user.name = auth['info']['name'] || ""
        user.email = auth['info']['email'] || ""

      end
    end
  end

  #gets user commitment deviation on a certain date. If no date is passed, it calculates it for today
  #This assumes that there is no hour commitment on weekends
  def commitmentDeviation(date = Time.now)
    if self.commitment_hours.blank?
       return "00:00"
    else
      timeNow= Time.now
      sum_hours =0
      sum_min =0
      if is_weekend(date)
        return "00:00"
      else
        entries = get_user_entries
        entries.each do |entry|
          if is_entry_from_date(entry,date)
            aux_time_entry = entry.hours.split(':')
            hours_entry=  aux_time_entry[0]
            min_entry= aux_time_entry[1]
            sum_hours = sum_hours + hours_entry.to_i
            sum_min= sum_min + min_entry.to_i
          end
        end

        aux_time_commitment_hours= self.commitment_hours.split(':')
        hours_commitment_hours= aux_time_commitment_hours[0]
        min_commitment_hours= aux_time_commitment_hours[1]

        if sum_hours >   hours_commitment_hours.to_i
          return ('00:00')  # Si la desviacion es negativa se retorna 0
        else
          if sum_min > min_commitment_hours.to_i
            total_hours_deviation= hours_commitment_hours.to_i-sum_hours-1 # Si la resta de min es negativa, hay que arreglar la solucion para que quede correcta
            if total_hours_deviation < 0
              return '00:00'
            end
            total_hours_deviation=total_hours_deviation.to_s
            total_min_deviation =  (60 - (sum_min - min_commitment_hours.to_i)).to_s
          else
            aux_total_hours_min=(sum_min- min_commitment_hours.to_i)/ 60
            total_hours_deviation= (hours_commitment_hours.to_i - (sum_hours + aux_total_hours_min)).to_s
            total_min_deviation =  (min_commitment_hours.to_i - (sum_min + (aux_total_hours_min * 60))).to_s
          end
        end

        if total_min_deviation.length == 1
          total_min_deviation= '0'+ total_min_deviation
        end

        if total_hours_deviation.length == 1
          total_hours_deviation= '0'+ total_hours_deviation
        end

        total_hours_deviation + ':' + total_min_deviation
      end
    end
  end

  #gets all entries made by the current user
  def get_user_entries
    Entry.where('user_id = ?',self.id)
  end

  private

  #returns true if date is sunday or saturday
  def is_weekend(date)
    sunday = 0
    saturday = 6
    ((date.wday == sunday) or (date.wday == saturday))
  end

  # return true if the entry= "entry" was created today
  # otherwise false
  def is_entry_from_date(entry,date)
    entryCreatedTime= entry.created_at
    (entryCreatedTime.year == date.year) and (entryCreatedTime.month == date.month) and (entryCreatedTime.day == date.day)
  end

end