Toombs::Application.routes.draw do

  resources :categories

  resources :tool_auths

  resources :cron_reports

  resources :users
  post '/auth/:provider/callback' => 'sessions#create'

  get '/auth/:provider/callback' => 'sessions#create'
  get '/signin_openid' => 'sessions#new_openid', :as => :signin_openid

  get '/signin' => 'sessions#new', :as => :signin
  get '/signout' => 'sessions#destroy', :as => :signout
  get '/auth/failure' => 'sessions#failure'


  resources :projects
  get 'projects/:id' => 'projects#show'

  resources :entries
  post 'entries/:id/initEntry' => 'entries#initEntry'
  get 'entries/:id/showCatComm' => 'entries#showCatComm'
  get 'entries/:id/initEntry' => 'entries#showCatComm'
  post 'tasks/:id/index' => 'entries#confirmEntry'
  get 'tasks/index' => 'entries#confirmEntry'
  get 'entries/:id/removeActualEntry' => 'entries#removeActualEntry'
  #post 'entries/:id/removeActualEntry' => 'entries#removeActualEntry'
  #get '/tasks/index' => 'entries#removeActualEntry'

  get 'tasks/search' => 'tasks#search'
  resources :tasks
  post 'tasks/:id/add_manual' => 'tasks#add_manual'
  post 'tasks/sync_tasks' => 'tasks#sync_tasks'
  post 'tasks/:id/stop' => 'tasks#stop'
  post 'tasks/:id/start' => 'tasks#start'

  # The priority is based upon order of creation: first created -> highest priority.
  # See how all your routes lay out with "rake routes".
  get 'home/menu' => 'home#menu'  , :as => :menu


  # You can have the root of your site routed with "root"
  root 'home#index'


  # Example of regular route:
  #   get 'products/:id' => 'catalog#view'

  # Example of named route that can be invoked with purchase_url(id: product.id)
  #   get 'products/:id/purchase' => 'catalog#purchase', as: :purchase

  # Example resource route (maps HTTP verbs to controller actions automatically):
  #   resources :products

  # Example resource route with options:
  #   resources :products do
  #     member do
  #       get 'short'
  #       post 'toggle'
  #     end
  #
  #     collection do
  #       get 'sold'
  #     end
  #   end

  # Example resource route with sub-resources:
  #   resources :products do
  #     resources :comments, :sales
  #     resource :seller
  #   end

  # Example resource route with more complex sub-resources:
  #   resources :products do
  #     resources :comments
  #     resources :sales do
  #       get 'recent', on: :collection
  #     end
  #   end
  
  # Example resource route with concerns:
  #   concern :toggleable do
  #     post 'toggle'
  #   end
  #   resources :posts, concerns: :toggleable
  #   resources :photos, concerns: :toggleable

  # Example resource route within a namespace:
  #   namespace :admin do
  #     # Directs /admin/products/* to Admin::ProductsController
  #     # (app/controllers/admin/products_controller.rb)
  #     resources :products
  #   end
end
