# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20131012212428) do

  create_table "categories", force: true do |t|
    t.text     "description"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.string   "state"
  end

  create_table "cron_reports", force: true do |t|
    t.integer  "periodicity_days"
    t.string   "filter"
    t.integer  "report_type"
    t.datetime "start_date"
    t.text     "emails"
    t.string   "project_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  create_table "entries", force: true do |t|
    t.date     "date"
    t.text     "comment"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "task_id"
    t.integer  "category_id"
    t.integer  "user_id"
    t.string   "hours"
    t.string   "status"
  end

  create_table "projects", force: true do |t|
    t.string   "name"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.string   "url"
    t.integer  "externalId"
  end

  create_table "projects_tool_auths", force: true do |t|
    t.integer "project_id"
    t.integer "tool_auth_id"
  end

  create_table "roles", force: true do |t|
    t.string   "name"
    t.integer  "resource_id"
    t.string   "resource_type"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "roles", ["name", "resource_type", "resource_id"], name: "index_roles_on_name_and_resource_type_and_resource_id", using: :btree
  add_index "roles", ["name"], name: "index_roles_on_name", using: :btree

  create_table "sync_entries", force: true do |t|
    t.integer "entry_id"
    t.integer "tool_auth_id"
    t.integer "sync_retries"
    t.string  "operation"
    t.text    "log"
  end

  create_table "sync_tasks", force: true do |t|
    t.integer "task_id"
    t.integer "tool_auth_id"
    t.integer "sync_retries"
    t.string  "operation"
    t.text    "log"
  end

  create_table "tasks", force: true do |t|
    t.string   "name"
    t.string   "status"
    t.string   "priority"
    t.date     "due_date"
    t.text     "description"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "project_id"
    t.integer  "user_id"
    t.string   "externalId"
    t.string   "external_project_id"
    t.text     "priorities"
    t.text     "next_status"
    t.text     "assignee"
    t.text     "estimation"
  end

  create_table "tool_auths", force: true do |t|
    t.string   "url"
    t.string   "tool_user"
    t.string   "password"
    t.string   "api_key"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.string   "tool_name"
    t.integer  "user_id"
  end

  create_table "users", force: true do |t|
    t.string   "email"
    t.string   "rol"
    t.string   "openid"
    t.string   "commitment_hours"
    t.boolean  "enabled"
    t.integer  "project_id"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "task_id"
    t.string   "provider"
    t.string   "name"
    t.string   "uid"
  end

  create_table "users_roles", id: false, force: true do |t|
    t.integer "user_id"
    t.integer "role_id"
  end

  add_index "users_roles", ["user_id", "role_id"], name: "index_users_roles_on_user_id_and_role_id", using: :btree

end
