# encoding: utf-8
# Función que dado un string de entrada retorna un area de búsqueda, y los criterios de tarea y proyecto a buscar
# Casos:
#        Entrada ==> search_string = @p: proyecto uno @t: primera tarea
#        Salida  ==> searching_area = tasks_of_projects
#                ==> critery_proy = proyecto uno  --  critery_task = primera tarea
#
#        Entrada ==> search_string = @t: primera tarea @p: proyecto uno
#        Salida  ==> searching_area = tasks_of_projects
#                ==> critery_proy = proyecto uno  --  critery_task = primera tarea
#
#        Entrada ==> search_string = @p: proyecto uno
#        Salida  ==> searching_area = only_projects
#                ==> critery_proy = proyecto uno  --  critery_task = nil
#
#        Entrada ==> search_string = @t: primera tarea
#        Salida  ==> searching_area = only_tasks
#                ==> critery_proy = nil --  critery_task = primera tarea
#
#        Entrada ==> search_string = uno y primera
#        Salida  ==> searching_area = tasks_or_projects
#                ==> critery_proy = uno y primera --  critery_task = uno y primera
#
#        Entrada ==> search_string = algo para @ buscar
#        Salida  ==> searching_area = not_critery
#                ==> critery_proy = nil  --  critery_task = nil
#
def parser_search_proy_task(search_string)

  expr_p = /^( *@p: *)((\w* *)+)$/
  expr_t = /^( *@t: *)((\w* *)+)$/
  expr_pt = /^( *@p: *)((\w* *)+)(@t: *)((\w* *)+)/
  expr_tp = /^( *@t: *)((\w* *)+)(@p: *)((\w* *)+)/
  expr_any = /^(( *\w* *)+)$/

  searching_area = ''
  critery_task = nil
  critery_proy = nil
  matchea = expr_p.match(search_string)

  if matchea
    searching_area = 'only_projects'
    critery_proy = matchea[2]
  else
    matchea = expr_t.match(search_string)
    if matchea
      searching_area = 'only_tasks'
      critery_task = matchea[2]
    else
      matchea_pt = expr_pt.match(search_string)
      matchea_tp = expr_tp.match(search_string)
      if (matchea_pt or matchea_tp)
        searching_area = 'tasks_of_projects'
        if matchea_pt
          critery_proy = matchea_pt[2]
          critery_task = matchea_pt[5]
        else
          critery_proy = matchea_tp[5]
          critery_task = matchea_tp[2]
        end
      else
        matchea = expr_any.match(search_string)
        if matchea
          searching_area = 'tasks_or_projects'
          critery_task = matchea[1]
          critery_proy = matchea[1]
        else
          searching_area = 'not_critery'
        end
      end
    end
  end
  return searching_area,critery_task,critery_proy
end
