require 'rubygems'
require 'httparty'
require 'json'


class RedMineClient
  include HTTParty
  format :json
  # It is the maximum number of issues to be present in the response
  OFFSET_LIMIT = 100
  HALF_HOUR = 30.0
  HALF_HOUR_REDMINE = 50.0
  attr_accessor :dataCurrentUser

  # Parameters: api_key =  key obtained from the redmine page
  #             base_uri =
  # Sets the class variables to use
  def initialize(api_key,base_uri)
    self.class.headers 'Content-Type' => 'application/json', 'X-Redmine-API-Key' => api_key
    self.class.base_uri  base_uri
  end

  # Parameters: None
  # Returns an error message if authentication failure
  # Content: Does the authentication with Redmine
  def doAuthentication()
    messeger=""
    begin
      @dataCurrentUser = self.class.get('/users/current.json')
      if dataCurrentUser.nil?
        messeger = "User doesn't exist"
      end
    rescue SocketError
      messeger = 'Connection ERROR'
    rescue MultiJson::LoadError
      messeger = 'Incorrect URL'
    rescue Exception
      messeger = 'Error validating credentials.'

    end

    return messeger
  end

  # Parameters: None
  # Return json collection of user associated projects
  def getProjects()
    user_projects = get_Membership_User()
  end

  # Parameters: None
  # returns a json-list of all issues associated with the current usuer
  # returns the follow messege if the key is incorrect: User dosen't exist
  # returns the follow messege if the application can't entablish connection: Connection Error
  def getIssuesUser()
    messeger = ''
    issues_All = []
    user_memberships = get_Membership_User()
    user_memberships.each do  |membership|

      project_ID = membership["project"]["id"]
      offset = 0
      issues = "Empty"
      issues_Per_Project = []
      while issues != []
        url_api_issues =  '/issues.json?project_id='
        url_api_issues_offset = url_api_issues + project_ID.to_s + "&offset=" + offset.to_s + "&limit=" + OFFSET_LIMIT.to_s
        json_issues = self.class.get(url_api_issues_offset)
        issues = json_issues["issues"]
        issues_Per_Project = issues_Per_Project + issues
        offset = offset + OFFSET_LIMIT
      end
      issues_All = issues_All + issues_Per_Project
    end
    messeger = issues_All
      #end

  rescue SocketError
    messeger= "Connection ERROR"

    return messeger
  end

  # Parameters: issue_id or project_id (only one is required): the issue id or project id to log time on
  #             spent_on: the date the time was spent (default to the current date) with format years-month-day
  #             hours (required): the number of spent hours with format hours:minutes
  #             activity_id: the id of the time activity. This parameter is required unless a default activity is defined in Redmine.
  #             comments: short description for the entry (255 characters max)
  #             creates a TimeEntry in Redmine with the parameters issue_id, spent_on,hours,activity_id,comments
  # Returns a json with the time entry created
  def create_Time_Entry(issue_id, date, time_spent, activity_id, comments)
    messeger = 'Successful entry.'
    spent_on = getDateInCorrectFormat(date)
    hours = getTimeSpentWorklogInCorrectFormat(time_spent)
    #IMPORTANT:  :query before the content
    self.class.post('/time_entries.json',{:query => {:time_entry => {"issue_id" => issue_id.to_s,"spent_on" =>spent_on,"hours" => hours,"activity_id" =>activity_id.to_s,"comments"=> comments}}})

  rescue SocketError
    messeger= "Connection ERROR"

    return messeger

  end

  def editRedMineIssue(task)

    priorityID= get_id_priority(task.priority)
    statusID= get_id_status(task.status)
    self.class.put("/issues/#{task.externalId.to_s}.json",{:query => { :issue => { 'subject' => task.name ,'description'=>task.description,'estimated_hours' => task.estimation,'priority_id' => priorityID ,'status_id'=> statusID ,'due_date'=>task.due_date.to_s}}} )
    ""      #lo agregue para que no devolviera nil y quedara igual que jira
  end

  def getPriorities()
    priorities = self.class.get('/enumerations/issue_priorities.json')
    priorities = priorities["issue_priorities"]
    priority_names = priorities.first['name']
    priorities.each do |priority|
      if priorities.first != priority
        priority_names = priority_names + ';' + priority['name']
      end
    end
    return priority_names
  end

  def getNextStatus(task_id)
    statuses = self.class.get('/issue_statuses.json')
    statuses = statuses["issue_statuses"]
    status_names = statuses.first['name']
    statuses.each do |status|
      if statuses.first != status
        status_names = status_names + ';' + status['name']
      end
    end
    return status_names
  end

  private

  def get_id_status(name_status)
    statuses =self.class.get('/issue_statuses.json')
    statuses= statuses["issue_statuses"]
    statuses.each do |status|
      if status["name"]== name_status
        return status["id"]
      end
    end
  end

  def get_id_priority(name_priority)
    priorities =self.class.get('/enumerations/issue_priorities.json')
    priorities= priorities["issue_priorities"]
    priorities.each do |priority|
      if priority["name"]== name_priority
        return priority["id"]
      end
    end
  end

  # Parameters: time_spent: String of the form 'HH: mm'
  # Returns a string with de Redmine format (number.number)
  def getTimeSpentWorklogInCorrectFormat(time_spent)
    aux_time = time_spent.split(':')
    minutes_conversion_redmine = (HALF_HOUR_REDMINE / HALF_HOUR).round(6)
    minutes = (aux_time[1].to_i.* minutes_conversion_redmine).round
    hours = aux_time[0].to_i
    resultado = hours.to_s + '.' + format('%02d', minutes)
    return resultado
  end

  # Parameters: date: Date put by user in FrontEnd
  # Check if date equals to actual date(format aaaa-mm-dd)
  # If it's actual date, convert it in the format being requested by Redmine
  # Otherwise, date is concatenated with a default time and default time zone in the format being requested by Redmine
  # Returns date in the format being requested by Redmine
  def getDateInCorrectFormat(date)
    date_auxiliar = date

    if date.to_s == Time.new().strftime('%Y-%m-%d')
      date_auxiliar = Time.new().strftime('%Y-%m-%d')
    end

    return date_auxiliar
  end

  # Parameters: None
  # From the current user returns an array of membership of a user
  # returns the follow messege if the key is incorrect: User dosen't exist
  # The membership conteins the data of a project
  def get_Membership_User()
    user =self.class.get('/users/current.json?&include=memberships')
    return user["user"]["memberships"]
  end

end