require 'test_helper'

class CronReportsControllerTest < ActionController::TestCase
  setup do
    @cron_report = cron_reports(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:cron_reports)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create cron_report" do
    assert_difference('CronReport.count') do
      post :create, cron_report: { emails: @cron_report.emails, filter: @cron_report.filter, periodicity_days: @cron_report.periodicity_days, project_id: @cron_report.project_id, start_date: @cron_report.start_date, report_type: @cron_report.report_type }
    end

    assert_redirected_to cron_report_path(assigns(:cron_report))
  end

  test "should show cron_report" do
    get :show, id: @cron_report
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @cron_report
    assert_response :success
  end

  test "should update cron_report" do
    patch :update, id: @cron_report, cron_report: { emails: @cron_report.emails, filter: @cron_report.filter, id: @cron_report.id, periodicity_days: @cron_report.periodicity_days, project_id: @cron_report.project_id, start_date: @cron_report.start_date, report_type: @cron_report.report_type }
    assert_redirected_to cron_report_path(assigns(:cron_report))
  end

  test "should destroy cron_report" do
    assert_difference('CronReport.count', -1) do
      delete :destroy, id: @cron_report
    end

    assert_redirected_to cron_reports_path
  end
end
