require 'test_helper'

class EntriesControllerTest < ActionController::TestCase
  setup do
    @entry = entries(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:entries)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should do initEntry" do
    assert_no_difference('Entry.count') do
      post :initEntry, :id => 1,:send_info => {hours: @entry.hours}, :entry => { category_id: @entry.category_id, comment: @entry.comment, date: @entry.date, hours: @entry.hours, task_id: @entry.task_id }
    end
    print @controller
    print @response
    assert_equal '1:00',assigns(:entry).hours
  end

  test "should do ConfirmEntry" do
    assert_difference('Entry.count') do
      #post :initEntry, :id => 1,:user_id => 1,:send_info => {hours: '01:30'}
      #puts @entry.task_id
      post :confirmEntry, :task_id => @entry.task_id, :user_id => @entry.user_id, :hours => @entry.hours, :entry => { cat_id: 1, comment: 'Testeando confirmEntry'}
    end

    assert_redirected_to tasks_path
  end

  test "should show entry" do
    get :show, id: @entry
    assert_response :success
  end

end
