require 'test_helper'

class SessionsControllerTest < ActionController::TestCase
  setup do
    request.env['omniauth.auth'] = OmniAuth.config.mock_auth[:google_oauth2]
  end

  test "should redirect to google" do
    post :new
    assert_redirected_to '/auth/google_oauth2'
  end

  test "should redirect to openid" do
    post :new_openid
    assert_redirected_to '/auth/google'
  end

  test "should successfully create a user" do
    assert_difference('User.count') do
      post :create, provider: :google_oauth2
    end
  end

  test "should successfully create a session" do
    assert_nil session[:user_id]
    post :create, provider: :google_oauth2
    assert_not_nil session[:user_id]
  end

  test "should redirect the user to the root url" do
    post :create, provider: :google_oauth2
    assert_redirected_to menu_url
  end

  test "should clear the session" do
    post :create, provider: :google_oauth2
    assert_not_nil session[:user_id]
    delete :destroy
    assert_nil session[:user_id]
  end

  test "should redirect to the home page" do
    post :create, provider: :google_oauth2
    delete :destroy
    assert_redirected_to root_url
  end

end
