require 'test_helper'

class TasksControllerTest < ActionController::TestCase
  setup do
    #@user = users(:one)
    @task = tasks(:one)
  end

  test "should start button" do
    get :index
    assert assigns(:task_groups).values.size >= 1  , 'tasks are not 1'
    assert_select '.start'
    assert_difference('Entry.count') do
      xhr :post, :start , id: @task.id
    end
  end

  test "should sync tasks" do
    get :index
    assert_response :success
    post :sync_tasks
    assert_redirected_to tasks_path
    assert_match 'Successfully', flash[:notice]
    get :index
    assert assigns(:task_groups).size > 1  , 'task groups size is not > 1'

  end


  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:tasks)

  end


  test "should show task" do
    get :show, id: @task
    assert_response :success
  end

end
