require 'test_helper'
require 'test/unit'

class TimerJobsControllerTest < ActionController::TestCase
  # test "the truth" do
  #   assert true
  # end

  # Set de pruebas con 12 horas horarios difrentes; observar que cron hace la operacion
  # modulo 24 para la horas y modo 60 para los minutos; asi que 27:15 => 3:15. Sin embargo
  # como tenemos objetos de tipo Time, los valores que pasamos para pasear deben ser coherentes.
  # Se utiliza formato de 24 horas;
  def setup
    @time_0 = Time.parse("9:23")
    @time_1 = Time.parse("12:45")
    @time_2 = Time.parse("10:24")
    @time_3 = Time.parse("20:10")
    @time_4 = Time.parse("12:45")
    @time_5 = Time.parse("3:55")
    @time_6 = Time.parse("0:15")
    @time_7 = Time.parse("20:00")
    @time_8 = Time.parse("14:08")
    @time_9 = Time.parse("23:23")
    @time_10 = Time.parse("03:23")
    @time_11 = Time.parse("05:02")
  end

  def	test0_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_0)

    time = @time_0.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test1_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_1)

    time = @time_1.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test2_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_2)

    time = @time_2.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test3_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_3)

    time = @time_3.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test4_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_4)

    time = @time_4.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test5_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_5)

    time = @time_5.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test6_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_6)

    time = @time_6.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test7_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_7)

    time = @time_7.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test8_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_8)

    time = @time_8.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test9_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_9)

    time = @time_9.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test10_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_10)

    time = @time_10.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

  def	test11_set_frequency_sync_tasks()
    # Invocamos la funcion del controlador que genera/actualiza el archivo schedule.rb.
    timerJobsController = TimerJobsController.new()
    timerJobsController.set_frequency_sync_tasks(@time_11)

    time = @time_11.to_s(:time)
    hours = time.split(":")[0]
    minutes = time.split(":")[1]

    file_name = "#{Rails.root}/config/schedule.rb"
    text = File.read(file_name)

    if ( text =~ /^every(\s+)1\.day,(\s+):at =>(\s+)'#{hours}:#{minutes}'(\s+)do(\s+)(runner(\s+)\"ToolSync\.run_SyncTask_To_DB_Global\(\)\")(\s+)end$/o )
      value = true
    else
      value = false
    end

    assert(value)
  end

end